/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.identity.idm.impl.configuration;

import org.jboss.identity.idm.spi.repository.IdentityStoreRepository;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityConfigurationMetaData;
import org.jboss.identity.idm.impl.api.session.mapper.IdentityObjectTypeMapper;

/**
 * @author <a href="mailto:boleslaw.dawidowicz at redhat.com">Boleslaw Dawidowicz</a>
 * @version : 0.1 $
 */
public class IdentitySessionConfigurationContext
{
   private final String realmName;
   private final IdentityConfigurationMetaData identityConfigurationMetaData;
   private final IdentityStoreRepository repository;
   private final IdentityObjectTypeMapper typeMapper;

   public IdentitySessionConfigurationContext(String realmName,
                                              IdentityConfigurationMetaData identityConfigurationMetaData,
                                              IdentityStoreRepository repository,
                                              IdentityObjectTypeMapper typeMapper)
   {
      this.realmName = realmName;
      this.identityConfigurationMetaData = identityConfigurationMetaData;
      this.repository = repository;
      this.typeMapper = typeMapper;
   }

   public String getRealmName()
   {
      return realmName;
   }

   public IdentityConfigurationMetaData getIdentityConfigurationMetaData()
   {
      return identityConfigurationMetaData;
   }

   public IdentityStoreRepository getRepository()
   {
      return repository;
   }

   public IdentityObjectTypeMapper getTypeMapper()
   {
      return typeMapper;
   }
}
