/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.store.hibernate;

import javax.persistence.Persistence;
import org.hibernate.Session;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.jboss.identity.idm.exception.IdentityException;
import org.jboss.identity.idm.spi.store.IdentityStoreSession;

public class HibernateIdentityStoreSessionImpl
implements IdentityStoreSession {
    private final Session hibernateSession;

    public HibernateIdentityStoreSessionImpl(Session hibernateSession) {
        this.hibernateSession = hibernateSession;
    }

    public HibernateIdentityStoreSessionImpl(String persistenceUnit) {
        HibernateEntityManagerFactory emFactory = (HibernateEntityManagerFactory)Persistence.createEntityManagerFactory((String)persistenceUnit);
        this.hibernateSession = emFactory.getSessionFactory().openSession();
    }

    public Object getSessionContext() {
        return this.hibernateSession;
    }

    public void close() throws IdentityException {
        this.hibernateSession.close();
    }

    public void save() throws IdentityException {
        this.hibernateSession.flush();
    }

    public void clear() throws IdentityException {
        this.hibernateSession.clear();
    }

    public boolean isOpen() {
        return this.hibernateSession.isOpen();
    }

    public boolean isTransactionSupported() {
        return true;
    }

    public void startTransaction() {
        this.hibernateSession.getTransaction().begin();
    }

    public void commitTransaction() {
        this.hibernateSession.getTransaction().commit();
    }

    public void rollbackTransaction() {
        this.hibernateSession.getTransaction().rollback();
    }

    public boolean isTransactionActive() {
        return this.hibernateSession.getTransaction().isActive();
    }
}

