/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.session.mapper;

import java.util.Collections;
import java.util.Map;
import org.jboss.identity.idm.api.GroupType;
import org.jboss.identity.idm.impl.api.model.SimpleGroupType;
import org.jboss.identity.idm.impl.api.session.mapper.IdentityObjectTypeMapper;
import org.jboss.identity.idm.impl.types.SimpleIdentityObjectType;
import org.jboss.identity.idm.spi.model.IdentityObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityObjectTypeMapperImpl
implements IdentityObjectTypeMapper {
    private final Map<String, String> groupTypeMap;
    private final String identityTypeName;

    public IdentityObjectTypeMapperImpl(Map<String, String> map, String identityTypeName) {
        this.groupTypeMap = Collections.unmodifiableMap(map);
        this.identityTypeName = identityTypeName;
    }

    @Override
    public IdentityObjectType getIdentityObjectType() {
        return new SimpleIdentityObjectType(this.identityTypeName);
    }

    @Override
    public IdentityObjectType getIdentityObjectType(GroupType groupType) {
        if (groupType == null) {
            throw new IllegalArgumentException("groupType is null");
        }
        for (Map.Entry<String, String> entry : this.groupTypeMap.entrySet()) {
            if (!entry.getValue().equals(groupType.getName())) continue;
            return new SimpleIdentityObjectType(entry.getKey());
        }
        return null;
    }

    @Override
    public GroupType getGroupType(IdentityObjectType identityObjectType) {
        if (identityObjectType == null) {
            throw new IllegalArgumentException("identityObjectType is null");
        }
        String name = this.groupTypeMap.get(identityObjectType.getName());
        if (name != null) {
            return new SimpleGroupType(name);
        }
        return null;
    }

    @Override
    public boolean isGroupType(IdentityObjectType identityObjectType) {
        if (identityObjectType == null) {
            throw new IllegalArgumentException("identityObjectType is null");
        }
        if (this.isIdentity(identityObjectType)) {
            return false;
        }
        return this.groupTypeMap.containsKey(identityObjectType.getName());
    }

    @Override
    public boolean isIdentity(IdentityObjectType identityObjectType) {
        if (identityObjectType == null) {
            throw new IllegalArgumentException("identityObjectType is null");
        }
        return identityObjectType.getName().equals(this.identityTypeName);
    }
}

