/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.session.managers;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.GroupType;
import org.jboss.identity.idm.api.Identity;
import org.jboss.identity.idm.api.IdentitySearchControl;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.IdentityType;
import org.jboss.identity.idm.api.RelationshipManager;
import org.jboss.identity.idm.api.RelationshipManagerFeaturesDescription;
import org.jboss.identity.idm.exception.IdentityException;
import org.jboss.identity.idm.impl.NotYetImplementedException;
import org.jboss.identity.idm.impl.api.session.managers.AbstractManager;
import org.jboss.identity.idm.spi.model.IdentityObject;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationshipType;
import org.jboss.identity.idm.spi.model.IdentityObjectType;
import org.jboss.identity.idm.spi.searchcontrol.IdentityObjectSearchControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipManagerImpl
extends AbstractManager
implements RelationshipManager {
    RelationshipManagerFeaturesDescription featuresDescription = new RelationshipManagerFeaturesDescription(){

        public boolean isIdentityAssociationSupported(GroupType fromGroupType) {
            IdentityObjectType identityOT = RelationshipManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
            IdentityObjectType groupIdentityOT = RelationshipManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(fromGroupType);
            try {
                return RelationshipManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isRelationshipTypeSupported(groupIdentityOT, identityOT, MEMBER);
            }
            catch (IdentityException e) {
                return false;
            }
        }

        public boolean isGroupAssociationSupported(GroupType fromGroupType, GroupType toGroupType) {
            IdentityObjectType toGroupOT = RelationshipManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(toGroupType);
            IdentityObjectType fromGroupOT = RelationshipManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(fromGroupType);
            try {
                return RelationshipManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isRelationshipTypeSupported(fromGroupOT, toGroupOT, MEMBER);
            }
            catch (IdentityException e) {
                return false;
            }
        }

        public boolean isIdentitiesSearchControlSupported(IdentitySearchControl control) {
            IdentityObjectType objectType = RelationshipManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
            if (control instanceof IdentityObjectSearchControl) {
                return RelationshipManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isControlSupported(objectType, (IdentityObjectSearchControl)control);
            }
            return false;
        }

        public boolean isIdentitiesSearchControlSupported(Class controlClazz) {
            IdentityObjectType objectType = RelationshipManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
            return RelationshipManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isControlSupported(objectType, controlClazz);
        }

        public boolean isGroupsSearchControlSupported(GroupType groupType, IdentitySearchControl control) {
            IdentityObjectType objectType = RelationshipManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(groupType);
            if (control instanceof IdentityObjectSearchControl) {
                return RelationshipManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isControlSupported(objectType, (IdentityObjectSearchControl)control);
            }
            return false;
        }

        public boolean isGroupsSearchControlSupported(GroupType groupType, Class controlClazz) {
            IdentityObjectType objectType = RelationshipManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(groupType);
            return RelationshipManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isControlSupported(objectType, controlClazz);
        }
    };
    public static final IdentityObjectRelationshipType MEMBER = new IdentityObjectRelationshipType(){

        public String getName() {
            return "JBOSS_IDENTITY_MEMBERSHIP";
        }
    };

    public RelationshipManagerImpl(IdentitySession session) {
        super(session);
    }

    public RelationshipManagerFeaturesDescription getFeaturesDescription() {
        return this.featuresDescription;
    }

    public void associateGroups(Collection<Group> parents, Collection<Group> members) throws IdentityException {
        for (Group parent : parents) {
            for (Group member : members) {
                this.associateGroups(parent, member);
            }
        }
    }

    public void associateGroups(Group parent, Group member) throws IdentityException {
        this.getRepository().createRelationship(this.getInvocationContext(), this.createIdentityObject(parent), this.createIdentityObject(member), MEMBER, null, true);
    }

    public void associateIdentities(Collection<Group> parents, Collection<Identity> members) throws IdentityException {
        for (Group parent : parents) {
            for (Identity member : members) {
                this.associateIdentities(parent, member);
            }
        }
    }

    public void associateIdentities(Group parent, Identity member) throws IdentityException {
        this.getRepository().createRelationship(this.getInvocationContext(), this.createIdentityObject(parent), this.createIdentityObject(member), MEMBER, null, true);
    }

    public void disassociateGroups(Collection<Group> parents, Collection<Group> members) throws IdentityException {
        for (Group parent : parents) {
            for (Group member : members) {
                this.getRepository().removeRelationship(this.getInvocationContext(), this.createIdentityObject(parent), this.createIdentityObject(member), MEMBER, null);
            }
        }
    }

    public void disassociateIdentities(Collection<Group> parents, Collection<Identity> members) throws IdentityException {
        for (Group parent : parents) {
            for (Identity member : members) {
                this.getRepository().removeRelationship(this.getInvocationContext(), this.createIdentityObject(parent), this.createIdentityObject(member), MEMBER, null);
            }
        }
    }

    public <G extends IdentityType, I extends IdentityType> boolean isAssociated(Collection<G> parents, Collection<I> members) throws IdentityException {
        for (IdentityType parent : parents) {
            for (IdentityType member : members) {
                Set relationships = this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(parent), this.createIdentityObject(member), MEMBER);
                if (relationships.size() != 0) continue;
                return false;
            }
        }
        return true;
    }

    public <G extends IdentityType, I extends IdentityType> boolean isAssociated(G parent, I member) throws IdentityException {
        HashSet<G> parents = new HashSet<G>();
        parents.add(parent);
        HashSet<I> members = new HashSet<I>();
        members.add(member);
        return this.isAssociated((G)parents, (I)members);
    }

    public Collection<Group> findAssociatedGroups(Group group, GroupType groupType, boolean parent, boolean inherited, IdentitySearchControl[] controls) throws IdentityException {
        LinkedList<Group> identities = new LinkedList<Group>();
        IdentityObjectType iot = this.getIdentityObjectType(groupType);
        if (inherited) {
            throw new NotYetImplementedException("Support for 'inherited' argument is not yet implemented. Please use 'false' value for now");
        }
        Collection ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(group), MEMBER, parent, this.convertSearchControls(controls));
        for (IdentityObject io : ios) {
            if (!io.getIdentityType().getName().equals(iot.getName())) continue;
            identities.add(this.createGroup(io));
        }
        return identities;
    }

    public Collection<Group> findAssociatedGroups(Group group, GroupType groupType, boolean parent, boolean inherited) throws IdentityException {
        return this.findAssociatedGroups(group, groupType, parent, inherited, null);
    }

    public Collection<Group> findAssociatedGroups(Identity identity, GroupType groupType, IdentitySearchControl[] controls) throws IdentityException {
        LinkedList<Group> identities = new LinkedList<Group>();
        IdentityObjectType iot = this.getIdentityObjectType(groupType);
        Collection ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(identity), MEMBER, false, this.convertSearchControls(controls));
        for (IdentityObject io : ios) {
            if (!io.getIdentityType().getName().equals(iot.getName())) continue;
            identities.add(this.createGroup(io));
        }
        return identities;
    }

    public Collection<Group> findAssociatedGroups(Identity identity, GroupType groupType) throws IdentityException {
        return this.findAssociatedGroups(identity, groupType, null);
    }

    public Collection<Group> findAssociatedGroups(Identity identity, IdentitySearchControl[] controls) throws IdentityException {
        LinkedList<Group> identities = new LinkedList<Group>();
        Collection ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(identity), MEMBER, false, this.convertSearchControls(controls));
        for (IdentityObject io : ios) {
            identities.add(this.createGroup(io));
        }
        return identities;
    }

    public Collection<Group> findAssociatedGroups(Identity identity) throws IdentityException {
        return this.findAssociatedGroups(identity, new IdentitySearchControl[0]);
    }

    public Collection<Identity> findAssociatedIdentities(Group group, boolean inherited, IdentitySearchControl[] controls) throws IdentityException {
        LinkedList<Identity> identities = new LinkedList<Identity>();
        if (inherited) {
            throw new NotYetImplementedException("Support for 'inherited' argument is not yet implemented. Please use 'false' value for now");
        }
        Collection ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(group), MEMBER, true, this.convertSearchControls(controls));
        for (IdentityObject io : ios) {
            identities.add(this.createIdentity(io));
        }
        return identities;
    }

    public Collection<Identity> findAssociatedIdentities(Group group, boolean inherited) throws IdentityException {
        return this.findAssociatedIdentities(group, inherited, null);
    }
}

