/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.session.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.identity.idm.api.Attribute;
import org.jboss.identity.idm.api.AttributeDescription;
import org.jboss.identity.idm.api.AttributesManager;
import org.jboss.identity.idm.api.Credential;
import org.jboss.identity.idm.api.CredentialType;
import org.jboss.identity.idm.api.Identity;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.IdentityType;
import org.jboss.identity.idm.exception.IdentityException;
import org.jboss.identity.idm.impl.api.PasswordCredential;
import org.jboss.identity.idm.impl.api.SimpleAttribute;
import org.jboss.identity.idm.impl.api.SimpleCredentialType;
import org.jboss.identity.idm.impl.api.attribute.IdentityObjectAttributeMetaDataImpl;
import org.jboss.identity.idm.impl.api.session.managers.AbstractManager;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.jboss.identity.idm.spi.model.IdentityObjectAttribute;
import org.jboss.identity.idm.spi.model.IdentityObjectCredential;
import org.jboss.identity.idm.spi.model.IdentityObjectCredentialType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributesManagerImpl
extends AbstractManager
implements AttributesManager {
    public AttributesManagerImpl(IdentitySession session) {
        super(session);
    }

    public AttributeDescription getAttributeDescription(IdentityType identityType, String name) {
        Map mdMap = this.getRepository().getAttributesMetaData(this.getInvocationContext(), this.createIdentityObject(identityType).getIdentityType());
        if (mdMap != null && mdMap.containsKey(name)) {
            IdentityObjectAttributeMetaData attributeMD = (IdentityObjectAttributeMetaData)mdMap.get(name);
            if (attributeMD instanceof AttributeDescription) {
                return (AttributeDescription)attributeMD;
            }
            return new IdentityObjectAttributeMetaDataImpl(attributeMD);
        }
        return null;
    }

    public Map<String, AttributeDescription> getSupportedAttributesDescriptions(IdentityType identityType) {
        Map mdMap = this.getRepository().getAttributesMetaData(this.getInvocationContext(), this.createIdentityObject(identityType).getIdentityType());
        HashMap<String, AttributeDescription> descriptionMap = new HashMap<String, AttributeDescription>();
        if (mdMap != null) {
            for (IdentityObjectAttributeMetaData attributeMD : mdMap.values()) {
                if (attributeMD instanceof AttributeDescription) {
                    descriptionMap.put(attributeMD.getName(), (AttributeDescription)attributeMD);
                    continue;
                }
                descriptionMap.put(attributeMD.getName(), new IdentityObjectAttributeMetaDataImpl(attributeMD));
            }
        }
        return descriptionMap;
    }

    public Set<String> getSupportedAttributeNames(IdentityType identityType) throws IdentityException {
        return this.getRepository().getSupportedAttributeNames(this.getInvocationContext(), this.createIdentityObject(identityType).getIdentityType());
    }

    public Map<String, Attribute> getAttributes(IdentityType identity) throws IdentityException {
        Map map = this.getRepository().getAttributes(this.getInvocationContext(), this.createIdentityObject(identity));
        HashMap<String, Attribute> newMap = new HashMap<String, Attribute>();
        for (Map.Entry entry : map.entrySet()) {
            newMap.put((String)entry.getKey(), this.convertAttribute((IdentityObjectAttribute)entry.getValue()));
        }
        return newMap;
    }

    public void updateAttributes(IdentityType identity, Attribute[] attributes) throws IdentityException {
        this.getRepository().updateAttributes(this.getInvocationContext(), this.createIdentityObject(identity), this.convertAttributes(attributes));
    }

    public Attribute getAttribute(IdentityType identity, String attributeName) throws IdentityException {
        return this.getAttributes(identity).get(attributeName);
    }

    public void addAttribute(IdentityType identity, String attributeName, Object[] values) throws IdentityException {
        Attribute[] attrs = new Attribute[]{new SimpleAttribute(attributeName, values)};
        this.addAttributes(identity, attrs);
    }

    public void addAttribute(IdentityType identity, String attributeName, Object value) throws IdentityException {
        Attribute[] attrs = new Attribute[]{new SimpleAttribute(attributeName, value)};
        this.addAttributes(identity, attrs);
    }

    public void addAttributes(IdentityType identity, Attribute[] attributes) throws IdentityException {
        this.getRepository().addAttributes(this.getInvocationContext(), this.createIdentityObject(identity), this.convertAttributes(attributes));
    }

    public void removeAttributes(IdentityType identity, String[] attributeNames) throws IdentityException {
        this.getRepository().removeAttributes(this.getInvocationContext(), this.createIdentityObject(identity), attributeNames);
    }

    public boolean hasPassword(Identity identity) throws IdentityException {
        return this.getRepository().getSupportedFeatures().isCredentialSupported(this.createIdentityObject(identity).getIdentityType(), (IdentityObjectCredentialType)PasswordCredential.TYPE);
    }

    public boolean validatePassword(Identity identity, String password) throws IdentityException {
        return this.getRepository().validateCredential(this.getInvocationContext(), this.createIdentityObject(identity), (IdentityObjectCredential)new PasswordCredential(password));
    }

    public void updatePassword(Identity identity, String password) throws IdentityException {
        this.getRepository().updateCredential(this.getInvocationContext(), this.createIdentityObject(identity), (IdentityObjectCredential)new PasswordCredential(password));
    }

    public boolean hasCredential(Identity identity, CredentialType credentialType) throws IdentityException {
        return this.getRepository().getSupportedFeatures().isCredentialSupported(this.createIdentityObject(identity).getIdentityType(), (IdentityObjectCredentialType)new SimpleCredentialType(credentialType.getName()));
    }

    public boolean validateCredentials(Identity identity, Credential[] credentials) throws IdentityException {
        for (Credential credential : credentials) {
            IdentityObjectCredential ioc = null;
            if (!(credential instanceof IdentityObjectCredential)) {
                throw new IdentityException("Unsupported Credential implementation: " + credential.getClass());
            }
            if (this.getRepository().validateCredential(this.getInvocationContext(), this.createIdentityObject(identity), ioc)) continue;
            return false;
        }
        return true;
    }

    public void updateCredential(Identity identity, Credential credential) throws IdentityException {
        if (!(credential instanceof IdentityObjectCredential)) {
            throw new IdentityException("Unsupported Credential implementation: " + credential.getClass());
        }
        this.getRepository().updateCredential(this.getInvocationContext(), this.createIdentityObject(identity), (IdentityObjectCredential)credential);
    }
}

