/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.identity.idm.impl.model.hibernate;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.Entity;
import javax.persistence.Table;

import org.hibernate.annotations.CollectionOfElements;

/**
 * @author <a href="mailto:boleslaw.dawidowicz at redhat.com">Boleslaw Dawidowicz</a>
 * @version : 0.1 $
 */
@Entity
@Table(name = "identity_obj_attrs_text")
public class HibernateIdentityObjectTextAttribute extends HibernateIdentityObjectAttribute
{

   @CollectionOfElements
   private Set<String> values = new HashSet<String>();

   public HibernateIdentityObjectTextAttribute()
   {
   }

   public HibernateIdentityObjectTextAttribute(HibernateIdentityObject identityObject, String name, Set<String> values)
   {
      super(identityObject, name);
      this.values = values;
   }

   public HibernateIdentityObjectTextAttribute(HibernateIdentityObject identityObject, String name, String[] values)
   {
      super(identityObject, name); 
   }

   public Set<String> getValues()
   {
      return Collections.unmodifiableSet(values);
   }

   public void setValues(Set<String> values)
   {
      this.values = values;
   }

   public String getValue()
   {
      if (values.size() > 0)
      {
         return values.iterator().next();
      }
      else
      {
         return null;
      }
   }

   public void addValue(Object value)
   {
      values.add(value.toString());
   }

   public int getSize()
   {
      return values.size();
   }


}
