/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.source;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.function.Function;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.key.KeyUtil;

public interface CredentialSource {
    public static final CredentialSource NONE = new CredentialSource(){

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
            return null;
        }
    };

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> var1, String var2, AlgorithmParameterSpec var3) throws IOException;

    default public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws IOException {
        Assert.checkNotNullParam("credentialType", credentialType);
        return this.getCredentialAcquireSupport(credentialType, algorithmName, null);
    }

    default public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType) throws IOException {
        Assert.checkNotNullParam("credentialType", credentialType);
        return this.getCredentialAcquireSupport(credentialType, null, null);
    }

    public <C extends Credential> C getCredential(Class<C> var1, String var2, AlgorithmParameterSpec var3) throws IOException;

    default public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws IOException {
        Assert.checkNotNullParam("credentialType", credentialType);
        return this.getCredential(credentialType, algorithmName, null);
    }

    default public <C extends Credential> C getCredential(Class<C> credentialType) throws IOException {
        Assert.checkNotNullParam("credentialType", credentialType);
        return this.getCredential(credentialType, null, null);
    }

    default public <C extends Credential, R> R applyToCredential(Class<C> credentialType, Function<C, R> function) throws IOException {
        C credential = this.getCredential(credentialType);
        return credential == null ? null : (R)credential.castAndApply(credentialType, function);
    }

    default public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, Function<C, R> function) throws IOException {
        C credential = this.getCredential(credentialType, algorithmName);
        return credential == null ? null : (R)credential.castAndApply(credentialType, algorithmName, function);
    }

    default public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec, Function<C, R> function) throws IOException {
        C credential = this.getCredential(credentialType, algorithmName, parameterSpec);
        return credential == null ? null : (R)credential.castAndApply(credentialType, algorithmName, parameterSpec, function);
    }

    default public CredentialSource with(final CredentialSource other) {
        final CredentialSource self = this;
        return new CredentialSource(){

            @Override
            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
                return SupportLevel.max(self.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec), other.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec));
            }

            @Override
            public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
                C credential = self.getCredential(credentialType, algorithmName, parameterSpec);
                if (credential != null) {
                    return credential;
                }
                return other.getCredential(credentialType, algorithmName, parameterSpec);
            }

            @Override
            public CredentialSource without(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
                CredentialSource filteredSelf = self.without(credentialType, algorithmName, parameterSpec);
                CredentialSource filteredOther = other.without(credentialType, algorithmName, parameterSpec);
                if (filteredSelf == NONE || filteredSelf == IdentityCredentials.NONE) {
                    if (filteredOther == NONE || filteredOther == IdentityCredentials.NONE) {
                        return NONE;
                    }
                    return filteredOther;
                }
                if (filteredOther == NONE || filteredOther == IdentityCredentials.NONE) {
                    return filteredSelf;
                }
                if (filteredSelf == self && filteredOther == other) {
                    return this;
                }
                return filteredSelf.with(filteredOther);
            }
        };
    }

    default public CredentialSource without(Class<? extends Credential> credentialType) {
        return this.without(credentialType, null, null);
    }

    default public CredentialSource without(Class<? extends Credential> credentialType, String algorithmName) {
        return this.without(credentialType, null, null);
    }

    default public CredentialSource without(final Class<? extends Credential> credentialType, final String algorithmName, final AlgorithmParameterSpec parameterSpec) {
        return new CredentialSource(){

            @Override
            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType2, String algorithmName2, AlgorithmParameterSpec parameterSpec2) throws IOException {
                if (this.isUnsupported(credentialType2, algorithmName2, parameterSpec2)) {
                    return SupportLevel.UNSUPPORTED;
                }
                return CredentialSource.this.getCredentialAcquireSupport(credentialType2, algorithmName2, parameterSpec2);
            }

            @Override
            public <C extends Credential> C getCredential(Class<C> credentialType2, String algorithmName2, AlgorithmParameterSpec parameterSpec2) throws IOException {
                if (this.isUnsupported(credentialType2, algorithmName2, parameterSpec2)) {
                    return null;
                }
                return CredentialSource.this.getCredential(credentialType2, algorithmName2, parameterSpec2);
            }

            private boolean isUnsupported(Class<? extends Credential> testCredentialType, String testAlgorithmName, AlgorithmParameterSpec testParameterSpec) {
                return !(!credentialType.isAssignableFrom(testCredentialType) || algorithmName != null && !algorithmName.equals(testAlgorithmName) || parameterSpec != null && !KeyUtil.parametersEqual(parameterSpec, testParameterSpec));
            }

            @Override
            public CredentialSource without(Class<? extends Credential> testCredentialType, String testAlgorithmName, AlgorithmParameterSpec testParameterSpec) {
                CredentialSource without = CredentialSource.this.without(testCredentialType, testAlgorithmName, testParameterSpec);
                if (without == NONE || without == IdentityCredentials.NONE) {
                    return NONE;
                }
                if (without == CredentialSource.this) {
                    return this;
                }
                return CredentialSource.super.without(credentialType, algorithmName, parameterSpec);
            }
        };
    }
}

