/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.password.interfaces.RawPassword;

class RawDigestPassword
extends RawPassword
implements DigestPassword {
    private static final long serialVersionUID = 7084601864990731347L;
    private final String username;
    private final String realm;
    private final byte[] digest;

    RawDigestPassword(String algorithm, String username, String realm, byte[] digest) {
        super(algorithm);
        this.username = username;
        this.realm = realm;
        this.digest = digest;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public byte[] getDigest() {
        return (byte[])this.digest.clone();
    }

    @Override
    public RawDigestPassword clone() {
        return this;
    }
}

