/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential;

import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import org.wildfly.common.Assert;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.key.KeyUtil;

public final class SecretKeyCredential
implements AlgorithmCredential {
    private final SecretKey secretKey;

    public SecretKeyCredential(SecretKey secretKey) {
        Assert.checkNotNullParam("secretKey", secretKey);
        this.secretKey = secretKey;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    @Override
    public boolean supportsParameters(Class<? extends AlgorithmParameterSpec> paramSpecClass) {
        return KeyUtil.getParameters(this.secretKey, paramSpecClass) != null;
    }

    @Override
    public <P extends AlgorithmParameterSpec> P getParameters(Class<P> paramSpecClass) {
        return KeyUtil.getParameters(this.secretKey, paramSpecClass);
    }

    @Override
    public boolean impliesSameParameters(AlgorithmCredential other) {
        return KeyUtil.hasParameters(this.secretKey, other.getParameters());
    }

    @Override
    public String getAlgorithm() {
        return this.secretKey.getAlgorithm();
    }

    @Override
    public SecretKeyCredential clone() {
        SecretKey secretKey = this.secretKey;
        SecretKey clone = KeyUtil.cloneKey(SecretKey.class, secretKey);
        return clone == secretKey ? this : new SecretKeyCredential(clone);
    }
}

