/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import javax.net.ssl.SSLContext;
import javax.security.sasl.SaslClientFactory;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.EndpointImpl;
import org.jboss.remoting3.ManagedConnection;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.xnio.FailedIoFuture;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

class FutureConnection {
    private final EndpointImpl endpoint;
    private final URI uri;
    private final AtomicReference<FutureResult<Connection>> futureConnectionRef = new AtomicReference();
    private final boolean immediate;
    private final OptionMap options;
    private final AuthenticationConfiguration configuration;
    private final UnaryOperator<SaslClientFactory> clientFactoryOperator;
    private final SecurityFactory<SSLContext> sslContextFactory;
    private final SocketAddress bindAddress;

    FutureConnection(EndpointImpl endpoint, SocketAddress bindAddress, URI uri, boolean immediate, OptionMap options, AuthenticationConfiguration configuration, UnaryOperator<SaslClientFactory> clientFactoryOperator, SecurityFactory<SSLContext> sslContextFactory) {
        this.endpoint = endpoint;
        this.bindAddress = bindAddress;
        this.uri = uri;
        this.immediate = immediate;
        this.options = options;
        this.configuration = configuration;
        this.clientFactoryOperator = clientFactoryOperator;
        this.sslContextFactory = sslContextFactory;
    }

    void reconnectAfterDelay() {
        this.endpoint.getXnioWorker().getIoThread().executeAfter(this::init, 30L, TimeUnit.SECONDS);
    }

    IoFuture<Connection> init() {
        return this.connect(null);
    }

    void splice(final FutureResult<Connection> futureResult, IoFuture<Connection> realFuture) {
        futureResult.addCancelHandler(realFuture);
        realFuture.addNotifier(new IoFuture.HandlingNotifier<Connection, FutureResult<Connection>>(){

            @Override
            public void handleCancelled(FutureResult<Connection> attachment) {
                attachment.setCancelled();
            }

            @Override
            public void handleFailed(IOException exception, FutureResult<Connection> attachment) {
                attachment.setException(exception);
            }

            @Override
            public void handleDone(Connection data, FutureResult<Connection> attachment) {
                attachment.setResult(new ManagedConnection(data, FutureConnection.this, futureResult));
            }
        }, futureResult);
    }

    IoFuture<Connection> connect(FutureResult<Connection> orig) {
        IoFuture<Connection> realFuture;
        AtomicReference<FutureResult<Connection>> futureConnectionRef = this.futureConnectionRef;
        FutureResult<Connection> oldVal = futureConnectionRef.get();
        if (oldVal != orig) {
            return oldVal.getIoFuture();
        }
        final FutureResult<Connection> futureResult = new FutureResult<Connection>();
        while (!futureConnectionRef.compareAndSet(oldVal, futureResult)) {
            oldVal = futureConnectionRef.get();
            if (oldVal == orig) continue;
            return oldVal.getIoFuture();
        }
        try {
            realFuture = this.endpoint.connect(this.uri, this.bindAddress, this.options, this.configuration, this.clientFactoryOperator, this.sslContextFactory);
        }
        catch (IOException e) {
            realFuture = new FailedIoFuture<Connection>(e);
        }
        this.splice(futureResult, realFuture);
        IoFuture<Connection> ioFuture = futureResult.getIoFuture();
        ioFuture.addNotifier(new IoFuture.HandlingNotifier<Connection, FutureConnection>(){

            @Override
            public void handleCancelled(FutureConnection attachment) {
                attachment.futureConnectionRef.set(null);
                if (attachment.immediate) {
                    attachment.reconnectAfterDelay();
                }
            }

            @Override
            public void handleFailed(IOException exception, FutureConnection attachment) {
                attachment.futureConnectionRef.set(null);
                if (attachment.immediate) {
                    attachment.reconnectAfterDelay();
                }
            }

            @Override
            public void handleDone(Connection connection, FutureConnection attachment) {
                connection.addCloseHandler((closed, exception) -> {
                    FutureConnection.this.clearRef(futureResult);
                    if (attachment.immediate) {
                        attachment.connect((FutureResult)attachment.futureConnectionRef.get());
                    }
                });
            }
        }, this);
        return ioFuture;
    }

    void clearRef(FutureResult<Connection> futureResult) {
        this.futureConnectionRef.compareAndSet(futureResult, null);
    }

    public IoFuture<Connection> get() {
        return this.init();
    }

    boolean isConnected() {
        FutureResult<Connection> futureResult = this.futureConnectionRef.get();
        return futureResult != null && futureResult.getIoFuture().getStatus() == IoFuture.Status.DONE;
    }
}

