/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.modelgraph.neo4j;

import com.google.common.net.HostAndPort;
import java.io.IOException;
import org.jboss.hal.modelgraph.neo4j.Cypher;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.exceptions.DatabaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Neo4jClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Neo4jClient.class);
    private final Driver driver;
    private final String webInterface;
    private long nodesCreated;
    private long relationsCreated;

    public Neo4jClient(HostAndPort hostAndPort, String username, String password, boolean clean) throws IOException {
        String uri = "bolt://" + hostAndPort;
        this.driver = GraphDatabase.driver(uri, AuthTokens.basic(username, password));
        this.webInterface = "http://" + hostAndPort.getHost() + ":7474/browser/";
        logger.info("Connected to Neo4j database at {}", (Object)hostAndPort);
        this.setup(clean);
    }

    private void setup(boolean clean) {
        Throwable throwable;
        Transaction tx2;
        Throwable throwable2;
        Session session;
        if (clean) {
            session = this.driver.session();
            throwable2 = null;
            try {
                tx2 = session.beginTransaction();
                throwable = null;
                try {
                    StatementResult result = tx2.run("MATCH (n) DETACH DELETE(n)");
                    logger.info("Removed {} nodes and {} relations", (Object)result.summary().counters().nodesDeleted(), (Object)result.summary().counters().relationshipsDeleted());
                    tx2.success();
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (tx2 != null) {
                        if (throwable != null) {
                            try {
                                tx2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            tx2.close();
                        }
                    }
                }
            }
            catch (Throwable tx2) {
                throwable2 = tx2;
                throw tx2;
            }
            finally {
                if (session != null) {
                    if (throwable2 != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable tx2) {
                            throwable2.addSuppressed(tx2);
                        }
                    } else {
                        session.close();
                    }
                }
            }
            this.failSafeDrop("DROP INDEX ON :Parameter(name)");
            this.failSafeDrop("DROP INDEX ON :Operation(name)");
            this.failSafeDrop("DROP INDEX ON :Capability(name)");
            this.failSafeDrop("DROP INDEX ON :Resource(name)");
            this.failSafeDrop("DROP CONSTRAINT ON (r:Resource) ASSERT r.address IS UNIQUE");
            this.failSafeDrop("DROP INDEX ON :Attribute(name)");
        }
        session = this.driver.session();
        throwable2 = null;
        try {
            tx2 = session.beginTransaction();
            throwable = null;
            try {
                tx2.run("CREATE INDEX ON :Resource(name)");
                tx2.run("CREATE CONSTRAINT ON (r:Resource) ASSERT r.address IS UNIQUE");
                tx2.run("CREATE INDEX ON :Attribute(name)");
                tx2.run("CREATE INDEX ON :Capability(name)");
                tx2.run("CREATE INDEX ON :Operation(name)");
                tx2.run("CREATE INDEX ON :Parameter(name)");
                tx2.success();
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (tx2 != null) {
                    if (throwable != null) {
                        try {
                            tx2.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        tx2.close();
                    }
                }
            }
        }
        catch (Throwable throwable7) {
            throwable2 = throwable7;
            throw throwable7;
        }
        finally {
            if (session != null) {
                if (throwable2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable8) {
                        throwable2.addSuppressed(throwable8);
                    }
                } else {
                    session.close();
                }
            }
        }
    }

    private void failSafeDrop(String statement) {
        try (Session session = this.driver.session();
             Transaction tx = session.beginTransaction();){
            tx.run(statement);
            tx.success();
        }
        catch (DatabaseException e) {
            logger.warn(e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    public StatementResult execute(Cypher cypher) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close() throws Exception {
        logger.debug("Closing connection to Neo4j database");
        this.driver.close();
    }

    public String getWebInterface() {
        return this.webInterface;
    }

    public long getNodesCreated() {
        return this.nodesCreated;
    }

    public long getRelationsCreated() {
        return this.relationsCreated;
    }
}

