/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.modelgraph.dmr;

import java.util.Iterator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.hal.modelgraph.dmr.ResourceAddress;

public class Operation
extends ModelNode {
    private final String name;
    private final ResourceAddress address;
    private final ModelNode parameter;

    Operation(String name, ResourceAddress address, ModelNode parameter) {
        this.name = name;
        this.address = address;
        this.parameter = parameter;
        this.init();
    }

    private void init() {
        this.set(this.parameter);
        this.get("operation").set(this.name);
        this.get("address").set(this.address);
    }

    @Override
    public String toString() {
        return this.asCli();
    }

    String asCli() {
        StringBuilder builder = new StringBuilder();
        if (this.address.isDefined() && !this.address.asList().isEmpty()) {
            builder.append(this.address);
        }
        builder.append(":").append(this.name);
        if (this.parameter.isDefined() && !this.parameter.asPropertyList().isEmpty()) {
            builder.append("(");
            Iterator<Property> iterator = this.parameter.asPropertyList().iterator();
            while (iterator.hasNext()) {
                Property p = iterator.next();
                builder.append(p.getName()).append("=").append(p.getValue().asString());
                if (!iterator.hasNext()) continue;
                builder.append(",");
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public static class Builder {
        private final String name;
        private final ResourceAddress address;
        private ModelNode parameter;

        public Builder(String name, ResourceAddress address) {
            this.address = address;
            this.name = name;
            this.parameter = new ModelNode();
        }

        public Builder param(String name, boolean value) {
            this.parameter.get(name).set(value);
            return this;
        }

        public Operation build() {
            return new Operation(this.name, this.address, this.parameter);
        }
    }
}

