/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.neo4j.driver.internal.NetworkSession;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;
import org.neo4j.driver.v1.exceptions.value.ValueException;
import org.neo4j.driver.v1.util.Function;

final class ClusterComposition {
    private static final long MAX_TTL = 9223372036854775L;
    private static final Function<Value, BoltServerAddress> OF_BoltServerAddress = new Function<Value, BoltServerAddress>(){

        @Override
        public BoltServerAddress apply(Value value) {
            return new BoltServerAddress(value.asString());
        }
    };
    private final Set<BoltServerAddress> readers = new HashSet<BoltServerAddress>();
    private final Set<BoltServerAddress> writers = new HashSet<BoltServerAddress>();
    private final Set<BoltServerAddress> routers = new HashSet<BoltServerAddress>();
    final long expirationTimestamp;

    private ClusterComposition(long expirationTimestamp) {
        this.expirationTimestamp = expirationTimestamp;
    }

    ClusterComposition(long expirationTimestamp, Set<BoltServerAddress> readers, Set<BoltServerAddress> writers, Set<BoltServerAddress> routers) {
        this(expirationTimestamp);
        this.readers.addAll(readers);
        this.writers.addAll(writers);
        this.routers.addAll(routers);
    }

    public boolean isValid() {
        return !this.routers.isEmpty() && !this.writers.isEmpty();
    }

    public Set<BoltServerAddress> readers() {
        return new HashSet<BoltServerAddress>(this.readers);
    }

    public Set<BoltServerAddress> writers() {
        return new HashSet<BoltServerAddress>(this.writers);
    }

    public Set<BoltServerAddress> routers() {
        return new HashSet<BoltServerAddress>(this.routers);
    }

    public String toString() {
        return "ClusterComposition{expirationTimestamp=" + this.expirationTimestamp + ", readers=" + this.readers + ", writers=" + this.writers + ", routers=" + this.routers + '}';
    }

    private static ClusterComposition read(Record record, long now) {
        if (record == null) {
            return null;
        }
        try {
            final ClusterComposition result = new ClusterComposition(ClusterComposition.expirationTimestamp(now, record));
            record.get("servers").asList(new Function<Value, Void>(){

                @Override
                public Void apply(Value value) {
                    result.servers(value.get("role").asString()).addAll(value.get("addresses").asList(OF_BoltServerAddress));
                    return null;
                }
            });
            return result;
        }
        catch (ValueException e) {
            return null;
        }
    }

    private static long expirationTimestamp(long now, Record record) {
        long ttl = record.get("ttl").asLong();
        long expirationTimestamp = now + ttl * 1000L;
        if (ttl < 0L || ttl >= 9223372036854775L || expirationTimestamp < 0L) {
            expirationTimestamp = Long.MAX_VALUE;
        }
        return expirationTimestamp;
    }

    private Set<BoltServerAddress> servers(String role) {
        switch (role) {
            case "READ": {
                return this.readers;
            }
            case "WRITE": {
                return this.writers;
            }
            case "ROUTE": {
                return this.routers;
            }
        }
        throw new IllegalArgumentException("invalid server role: " + role);
    }

    static interface Provider {
        public static final String GET_SERVERS = "CALL dbms.cluster.routing.getServers";

        public ClusterComposition getClusterComposition(Connection var1) throws ServiceUnavailableException;

        public static final class Default
        implements Provider {
            private static final Statement GET_SERVER = new Statement("CALL dbms.cluster.routing.getServers");
            private final Clock clock;
            private final Logger log;

            Default(Clock clock, Logger log) {
                this.clock = clock;
                this.log = log;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ClusterComposition getClusterComposition(Connection connection) throws ServiceUnavailableException {
                StatementResult cursor = this.getServers(connection);
                List<Record> records = cursor.list();
                this.log.info("Got getServers response: %s", records);
                long now = this.clock.millis();
                try {
                    if (records.size() != 1) {
                        ClusterComposition clusterComposition = null;
                        return clusterComposition;
                    }
                    ClusterComposition clusterComposition = ClusterComposition.read(records.get(0), now);
                    return clusterComposition;
                }
                finally {
                    cursor.consume();
                }
            }

            private StatementResult getServers(Connection connection) {
                return NetworkSession.run(connection, GET_SERVER);
            }
        }
    }
}

