/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;
import org.jboss.remoting3.AbstractDelegatingMessageOutputStream;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3._private.IntIndexHashMap;
import org.jboss.remoting3._private.IntIndexMap;
import org.jboss.remoting3.util.Invocation;
import org.jboss.remoting3.util.MessageTracker;
import org.wildfly.common.Assert;

public final class InvocationTracker {
    private final IntIndexMap<Invocation> invocations = new IntIndexHashMap<Invocation>(Invocation::getIndex);
    private final MessageTracker messageTracker;
    private final IntUnaryOperator intMasker;

    public InvocationTracker(Channel channel, int maxMessages, IntUnaryOperator intMasker) {
        this(channel, new MessageTracker(channel, maxMessages), intMasker);
    }

    public InvocationTracker(Channel channel, MessageTracker messageTracker, IntUnaryOperator intMasker) {
        Assert.checkNotNullParam("channel", channel);
        Assert.checkNotNullParam("messageTracker", messageTracker);
        Assert.checkNotNullParam("intMasker", intMasker);
        this.messageTracker = messageTracker;
        channel.addCloseHandler((closed, exception) -> this.connectionClosed());
        this.intMasker = intMasker;
    }

    public InvocationTracker(Channel channel, IntUnaryOperator intMasker) {
        this(channel, channel.getOption(RemotingOptions.MAX_OUTBOUND_MESSAGES), intMasker);
    }

    public InvocationTracker(Channel channel, int maxMessages) {
        this(channel, maxMessages, InvocationTracker::defaultFunction);
    }

    public InvocationTracker(Channel channel) {
        this(channel, channel.getOption(RemotingOptions.MAX_OUTBOUND_MESSAGES), InvocationTracker::defaultFunction);
    }

    private static int defaultFunction(int random) {
        return random & 0xFFFF;
    }

    public <T extends Invocation> T addInvocation(IntFunction<T> producer) {
        Invocation invocation;
        int id;
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        IntUnaryOperator intMasker = this.intMasker;
        IntIndexMap<Invocation> invocations = this.invocations;
        while (invocations.containsKey(id = intMasker.applyAsInt(threadLocalRandom.nextInt())) || invocations.putIfAbsent(invocation = (Invocation)producer.apply(id)) != null) {
        }
        return (T)invocation;
    }

    public boolean containsIndex(int index) {
        return this.invocations.containsKey(index);
    }

    public Invocation putIfAbsent(Invocation invocation) {
        return this.invocations.putIfAbsent(invocation);
    }

    public boolean signalResponse(int index, int parameter, MessageInputStream responseStream, boolean remove) {
        Invocation invocation;
        Invocation invocation2 = invocation = remove ? this.invocations.removeKey(index) : this.invocations.get(index);
        if (invocation == null) {
            return false;
        }
        invocation.handleResponse(parameter, responseStream);
        return true;
    }

    public void remove(Invocation invocation) {
        this.invocations.remove(invocation);
    }

    public MessageOutputStream allocateMessage() throws IOException {
        try {
            return this.messageTracker.openMessage();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("Message allocation interrupted");
        }
    }

    public MessageOutputStream allocateMessage(final Invocation invocation) throws IOException {
        return new AbstractDelegatingMessageOutputStream(this.allocateMessage()){

            @Override
            public MessageOutputStream cancel() {
                super.cancel();
                InvocationTracker.this.remove(invocation);
                return this;
            }
        };
    }

    private void connectionClosed() {
        Iterator iterator = this.invocations.iterator();
        while (iterator.hasNext()) {
            Invocation invocation = (Invocation)iterator.next();
            try {
                invocation.handleClosed();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            iterator.remove();
        }
    }
}

