/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.modelgraph;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.hal.modelgraph.dmr.Operation;
import org.jboss.hal.modelgraph.dmr.ResourceAddress;
import org.jboss.hal.modelgraph.dmr.WildFlyClient;
import org.jboss.hal.modelgraph.neo4j.Cypher;
import org.jboss.hal.modelgraph.neo4j.Neo4jClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Analyzer {
    private static final int MAX_DEPTH = 10;
    private static final Logger logger = LoggerFactory.getLogger(Analyzer.class);
    private static final Set<String> GLOBAL_OPERATIONS = Sets.newHashSet("list-add", "list-clear", "list-get", "list-remove", "map-clear", "map-get", "map-put", "map-remove", "query", "read-attribute", "read-attribute-group", "read-attribute-group-names", "read-children-names", "read-children-resources", "read-children-types", "read-operation-description", "read-operation-names", "read-resource-description", "read-resource", "remove", "undefine-attribute", "whoami", "write-attribute");
    private final WildFlyClient wc;
    private final Neo4jClient nc;
    private long[] resources;
    private final Set<String> missingGlobalOperations;

    Analyzer(WildFlyClient wc, Neo4jClient nc) {
        this.wc = wc;
        this.nc = nc;
        this.resources = new long[2];
        this.missingGlobalOperations = new HashSet<String>(GLOBAL_OPERATIONS);
    }

    void start(String resource) {
        this.parse(ResourceAddress.of(resource), null);
    }

    private void parse(ResourceAddress address, ResourceAddress parent) {
        if (address.size() < 10) {
            this.parseResource(address, parent);
            this.readChildren(address).forEach(child -> this.parse(address.add((String)child), address));
        } else {
            logger.warn("Skipping {}. Maximum nesting of {} reached.", (Object)address.toString(), (Object)10);
        }
    }

    private void parseResource(ResourceAddress address, ResourceAddress parent) {
        Operation rrd = new Operation.Builder("read-resource-description", address).param("include-aliases", true).param("operations", true).build();
        ModelNode resourceDescription = this.wc.execute(rrd);
        if (resourceDescription.isDefined()) {
            List<ModelNode> descriptions;
            logger.info("Read {}", (Object)address.toString());
            if (resourceDescription.getType() == ModelType.LIST && !(descriptions = resourceDescription.asList()).isEmpty() && descriptions.get(0).hasDefined("result")) {
                resourceDescription = descriptions.get(0).get("result");
            }
            this.createResource(address);
            if (parent != null) {
                this.mergeChildOf(address, parent);
            }
            if (resourceDescription.hasDefined("capabilities")) {
                resourceDescription.get("capabilities").asList().stream().map(modelNode -> modelNode.get("name").asString()).forEach(capability -> this.mergeCapabilities(address, (String)capability));
            }
            if (resourceDescription.hasDefined("attributes")) {
                ArrayListMultimap alternatives = ArrayListMultimap.create();
                ArrayListMultimap requires = ArrayListMultimap.create();
                resourceDescription.get("attributes").asPropertyList().forEach(property -> {
                    String name = property.getName();
                    ModelNode attribute = property.getValue();
                    this.mergeAttribute(address, name, attribute);
                    if (attribute.hasDefined("alternatives")) {
                        List a = attribute.get("alternatives").asList().stream().map(ModelNode::asString).collect(Collectors.toList());
                        alternatives.putAll(name, a);
                    }
                    if (attribute.hasDefined("requires")) {
                        List r = attribute.get("requires").asList().stream().map(ModelNode::asString).collect(Collectors.toList());
                        requires.putAll(name, r);
                    }
                });
                alternatives.entries().forEach(entry -> this.mergeAttributeRelation(address, (String)entry.getKey(), (String)entry.getValue(), "-[:ALTERNATIVE]-"));
                requires.entries().forEach(entry -> this.mergeAttributeRelation(address, (String)entry.getKey(), (String)entry.getValue(), "-[:REQUIRES]->"));
            }
            if (resourceDescription.hasDefined("operations")) {
                resourceDescription.get("operations").asPropertyList().forEach(op -> {
                    boolean create;
                    String name = op.getName();
                    ModelNode operation = op.getValue();
                    boolean globalOperation = GLOBAL_OPERATIONS.contains(name);
                    boolean bl = create = !globalOperation || this.missingGlobalOperations.contains(name);
                    if (create) {
                        this.mergeOperation(address, name, operation, globalOperation);
                        if (operation.hasDefined("request-properties")) {
                            ArrayListMultimap alternatives = ArrayListMultimap.create();
                            ArrayListMultimap requires = ArrayListMultimap.create();
                            operation.get("request-properties").asPropertyList().forEach(rp -> {
                                String rpName = rp.getName();
                                ModelNode requestProperty = rp.getValue();
                                this.mergeRequestProperty(address, name, rpName, requestProperty);
                                if (requestProperty.hasDefined("alternatives")) {
                                    List a = requestProperty.get("alternatives").asList().stream().map(ModelNode::asString).collect(Collectors.toList());
                                    alternatives.putAll(rpName, a);
                                }
                                if (requestProperty.hasDefined("requires")) {
                                    List r = requestProperty.get("requires").asList().stream().map(ModelNode::asString).collect(Collectors.toList());
                                    requires.putAll(rpName, r);
                                }
                            });
                            alternatives.entries().forEach(entry -> this.mergeRequestPropertyRelation(address, name, (String)entry.getKey(), (String)entry.getValue(), "-[:ALTERNATIVE]-"));
                            requires.entries().forEach(entry -> this.mergeRequestPropertyRelation(address, name, (String)entry.getKey(), (String)entry.getValue(), "-[:REQUIRES]->"));
                        }
                        if (globalOperation) {
                            this.missingGlobalOperations.remove(name);
                        }
                    } else {
                        this.linkGlobalOperation(address, name);
                    }
                });
            }
            this.resources[1] = this.resources[1] + 1L;
        } else {
            this.resources[0] = this.resources[0] + 1L;
        }
    }

    private List<String> readChildren(ResourceAddress address) {
        Operation rct = new Operation.Builder("read-children-types", address).param("include-singletons", true).build();
        ModelNode result = this.wc.execute(rct);
        if (result.isDefined()) {
            return result.asList().stream().map(ModelNode::asString).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void createResource(ResourceAddress address) {
        Cypher cypher = new Cypher("CREATE (:Resource {").append("name", address.getName()).comma().append("address", address.toString()).comma().append("singleton", address.isSingleton()).append("})");
        this.nc.execute(cypher);
    }

    private void mergeChildOf(ResourceAddress child, ResourceAddress parent) {
        Cypher cypher = new Cypher("MATCH (child:Resource {").append("address", "child", child.toString()).append("}),").append("(parent:Resource {").append("address", "parent", parent.toString()).append("})").append(" MERGE (child)-[:CHILD_OF]->(parent)");
        this.nc.execute(cypher);
    }

    private void mergeCapabilities(ResourceAddress address, String capability) {
        Cypher cypher = new Cypher("MATCH (r:Resource {").append("address", address.toString()).append("})").append(" MERGE (r)-[:DECLARES_CAPABILITY]->(:Capability {").append("name", capability).append("})");
        this.nc.execute(cypher);
    }

    private void mergeAttribute(ResourceAddress address, String name, ModelNode attribute) {
        Cypher cypher = new Cypher("MATCH (r:Resource {").append("address", address.toString()).append("})").append(" MERGE (r)-[:HAS_ATTRIBUTE]->(a:Attribute {").append("name", name);
        this.addIfPresent(cypher, "access-type", attribute, ModelNode::asString);
        this.addIfPresent(cypher, "alias", attribute, ModelNode::asString);
        this.addIfPresent(cypher, "attribute-group", attribute, ModelNode::asString);
        this.addIfPresent(cypher, "default", attribute, ModelNode::asString);
        this.addIfPresent(cypher, "expressions-allowed", attribute, ModelNode::asBoolean);
        this.addIfPresent(cypher, "max", attribute, ModelNode::asLong);
        this.addIfPresent(cypher, "max-length", attribute, ModelNode::asLong);
        this.addIfPresent(cypher, "min", attribute, ModelNode::asLong);
        this.addIfPresent(cypher, "min-length", attribute, ModelNode::asLong);
        this.addIfPresent(cypher, "nillable", attribute, ModelNode::asBoolean);
        this.addIfPresent(cypher, "required", attribute, ModelNode::asBoolean);
        this.addIfPresent(cypher, "restart-required", attribute, ModelNode::asString);
        this.addIfPresent(cypher, "storage", attribute, ModelNode::asString);
        this.addIfPresent(cypher, "type", attribute, value -> value.asType().name());
        this.addIfPresent(cypher, "unit", attribute, ModelNode::asString);
        this.addDeprecated(cypher, attribute);
        this.addValueType(cypher, attribute);
        cypher.append("})");
        if (attribute.hasDefined("capability-reference")) {
            String capabilityReference = attribute.get("capability-reference").asString();
            cypher.append(" MERGE (a)-[:REFERENCES_CAPABILITY]-(:Capability {").append("name", "capability-reference", capabilityReference).append("})");
        }
        this.nc.execute(cypher);
    }

    private void mergeAttributeRelation(ResourceAddress address, String source, String target, String relation) {
        Cypher cypher = new Cypher("MATCH (:Resource {").append("address", address.toString()).append("})").append("-[:HAS_ATTRIBUTE]->(source:Attribute {").append("name", "sourceName", source).append("}),").append("(:Resource {").append("address", address.toString()).append("})").append("-[:HAS_ATTRIBUTE]->(target:Attribute {").append("name", "targetName", target).append("})").append(" MERGE (source)").append(relation).append("(target)");
        this.nc.execute(cypher);
    }

    private void mergeOperation(ResourceAddress address, String name, ModelNode operation, boolean globalOperation) {
        ModelNode replyNode;
        Cypher cypher = new Cypher("MATCH (r:Resource {").append("address", address.toString()).append("})").append(" MERGE (r)-[:PROVIDES]->(o:Operation {").append("name", name).comma().append("global", globalOperation || "add".equals(name));
        this.addIfPresent(cypher, "read-only", operation, ModelNode::asBoolean);
        this.addIfPresent(cypher, "runtime-only", operation, ModelNode::asBoolean);
        if (operation.hasDefined("reply-properties") && (replyNode = operation.get("reply-properties")).isDefined()) {
            this.addIfPresent(cypher, "return", replyNode, "type", value -> value.asType().name());
            this.addValueType(cypher, replyNode);
        }
        cypher.append("})");
        this.nc.execute(cypher);
    }

    private void mergeRequestProperty(ResourceAddress address, String operationName, String requestPropertyName, ModelNode requestProperty) {
        Cypher cypher = new Cypher("MATCH (r:Resource {").append("address", address.toString()).append("})-[:PROVIDES]->(o:Operation {").append("name", "operation-name", operationName).append("})").append(" MERGE (o)-[:ACCEPTS]->(p:Parameter {").append("name", requestPropertyName);
        this.addIfPresent(cypher, "expressions-allowed", requestProperty, ModelNode::asBoolean);
        this.addIfPresent(cypher, "max", requestProperty, ModelNode::asLong);
        this.addIfPresent(cypher, "max-length", requestProperty, ModelNode::asLong);
        this.addIfPresent(cypher, "min", requestProperty, ModelNode::asLong);
        this.addIfPresent(cypher, "min-length", requestProperty, ModelNode::asLong);
        this.addIfPresent(cypher, "nillable", requestProperty, ModelNode::asBoolean);
        this.addIfPresent(cypher, "required", requestProperty, ModelNode::asBoolean);
        this.addIfPresent(cypher, "type", requestProperty, value -> value.asType().name());
        this.addIfPresent(cypher, "unit", requestProperty, ModelNode::asString);
        this.addDeprecated(cypher, requestProperty);
        cypher.append("})");
        if (requestProperty.hasDefined("capability-reference")) {
            String capabilityReference = requestProperty.get("capability-reference").asString();
            cypher.append(" MERGE (p)-[:REFERENCES_CAPABILITY]-(:Capability {").append("name", "capability-reference", capabilityReference).append("})");
        }
        this.nc.execute(cypher);
    }

    private void mergeRequestPropertyRelation(ResourceAddress address, String operation, String source, String target, String relation) {
        Cypher cypher = new Cypher("MATCH (:Resource {").append("address", address.toString()).append("})").append("-[:PROVIDES]->(o:Operation {").append("name", "operation-name", operation).append("}),").append("(o)-[:ACCEPTS]->(source:Parameter {").append("name", "sourceName", source).append("}),").append("(o)-[:ACCEPTS]->(target:Parameter {").append("name", "targetName", target).append("})").append(" MERGE (source)").append(relation).append("(target)");
        this.nc.execute(cypher);
    }

    private void linkGlobalOperation(ResourceAddress address, String operationName) {
        Cypher cypher = new Cypher("MATCH (r:Resource {").append("address", address.toString()).append("}),").append("(o:Operation{").append("name", operationName).append("})").append(" MERGE (r)-[:PROVIDES]->(o)");
        this.nc.execute(cypher);
    }

    private void addDeprecated(Cypher cypher, ModelNode modelNode) {
        if (modelNode.hasDefined("deprecated")) {
            cypher.comma().append("deprecated", true);
            ModelNode deprecatedNode = modelNode.get("deprecated");
            this.addIfPresent(cypher, "since", deprecatedNode, ModelNode::asString);
        }
    }

    private void addValueType(Cypher cypher, ModelNode modelNode) {
        if (modelNode.hasDefined("value-type")) {
            ModelNode valueTypeNode = modelNode.get("value-type");
            try {
                ModelType valueType = valueTypeNode.asType();
                cypher.comma().append("value-type", valueType.name());
            }
            catch (IllegalArgumentException e) {
                cypher.comma().append("value-type", ModelType.OBJECT.name());
            }
        }
    }

    private <T> void addIfPresent(Cypher cypher, String name, ModelNode modelNode, Function<ModelNode, T> getValue) {
        this.addIfPresent(cypher, name, modelNode, name, getValue);
    }

    private <T> void addIfPresent(Cypher cypher, String name, ModelNode modelNode, String attribute, Function<ModelNode, T> getValue) {
        if (modelNode.hasDefined(attribute)) {
            ModelNode value = modelNode.get(attribute);
            cypher.comma().append(name, getValue.apply(value));
        }
    }

    long getSuccessfulResources() {
        return this.resources[1];
    }

    long getFailedResources() {
        return this.resources[0];
    }
}

