/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential;

import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import org.wildfly.common.Assert;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.key.KeyUtil;

public final class PublicKeyCredential
implements AlgorithmCredential {
    private final PublicKey publicKey;

    public PublicKeyCredential(PublicKey publicKey) {
        Assert.checkNotNullParam("publicKey", publicKey);
        this.publicKey = publicKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public boolean supportsParameters(Class<? extends AlgorithmParameterSpec> paramSpecClass) {
        return KeyUtil.getParameters(this.publicKey, paramSpecClass) != null;
    }

    @Override
    public <P extends AlgorithmParameterSpec> P getParameters(Class<P> paramSpecClass) {
        return KeyUtil.getParameters(this.publicKey, paramSpecClass);
    }

    @Override
    public boolean impliesSameParameters(AlgorithmCredential other) {
        return KeyUtil.hasParameters(this.publicKey, other.getParameters());
    }

    @Override
    public String getAlgorithm() {
        return this.publicKey.getAlgorithm();
    }

    @Override
    public PublicKeyCredential clone() {
        return this;
    }
}

