/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor.mbui;

import java.util.ArrayList;
import java.util.List;
import org.jboss.hal.processor.mbui.ExpressionParser;

public class Attribute {
    private final String name;
    private final String formItem;
    private final String provider;
    private final String validationHandler;
    private final String suggestHandler;
    private final List<String> suggestHandlerTemplates;

    Attribute(String name, String provider, String formItem, String validationHandler, String suggestHandler) {
        this.name = name;
        this.provider = ExpressionParser.stripExpression(provider);
        this.formItem = ExpressionParser.stripExpression(formItem);
        this.validationHandler = ExpressionParser.stripExpression(validationHandler);
        this.suggestHandler = ExpressionParser.stripExpression(suggestHandler);
        this.suggestHandlerTemplates = new ArrayList<String>();
    }

    public String getName() {
        return this.name;
    }

    public String getFormItem() {
        return this.formItem;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getValidationHandler() {
        return this.validationHandler;
    }

    public String getSuggestHandler() {
        return this.suggestHandler;
    }

    public List<String> getSuggestHandlerTemplates() {
        return this.suggestHandlerTemplates;
    }

    void addSuggestHandlerTemplate(String template) {
        this.suggestHandlerTemplates.add(template);
    }
}

