/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor;

import com.google.auto.service.AutoService;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.jboss.auto.AbstractProcessor;
import org.jboss.hal.spi.AsyncColumn;
import org.jboss.hal.spi.Column;

@SupportedAnnotationTypes(value={"org.jboss.hal.spi.Column", "org.jboss.hal.spi.AsyncColumn"})
@AutoService(value={Processor.class})
public class ColumnRegistrationProcessor
extends AbstractProcessor {
    private static final String COLUMN_INIT_TEMPLATE = "ColumnInit.ftl";
    private static final String COLUMN_INIT_PACKAGE = "org.jboss.hal.client.finder";
    private static final String COLUMN_INIT_CLASS = "ColumnInit";
    private static final String COLUMN_MODULE_TEMPLATE = "ColumnModule.ftl";
    private static final String COLUMN_MODULE_PACKAGE = "org.jboss.hal.client.finder";
    private static final String COLUMN_MODULE_CLASS = "ColumnModule";
    private final Set<ColumnInfo> columnInfos = new LinkedHashSet<ColumnInfo>();

    public ColumnRegistrationProcessor() {
        super(ColumnRegistrationProcessor.class, "templates");
    }

    protected boolean onProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ColumnInfo columnInfo;
        for (Element element : roundEnv.getElementsAnnotatedWith(AsyncColumn.class)) {
            columnInfo = this.columnInfo((TypeElement)element, true);
            this.columnInfos.add(columnInfo);
            this.debug("Discovered async finder column [%s]", new Object[]{columnInfo});
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Column.class)) {
            columnInfo = this.columnInfo((TypeElement)element, false);
            this.columnInfos.add(columnInfo);
            this.debug("Discovered finder column [%s]", new Object[]{columnInfo});
        }
        if (!this.columnInfos.isEmpty()) {
            this.debug("Generating code for column init", new Object[0]);
            this.code(COLUMN_INIT_TEMPLATE, "org.jboss.hal.client.finder", COLUMN_INIT_CLASS, () -> {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("generatedWith", ColumnRegistrationProcessor.class.getName());
                context.put("packageName", "org.jboss.hal.client.finder");
                context.put("className", COLUMN_INIT_CLASS);
                context.put("columnInfos", this.columnInfos);
                return context;
            });
            this.debug("Generating code for column module", new Object[0]);
            this.code(COLUMN_MODULE_TEMPLATE, "org.jboss.hal.client.finder", COLUMN_MODULE_CLASS, () -> {
                HashMap<String, String> context = new HashMap<String, String>();
                context.put("generatedWith", ColumnRegistrationProcessor.class.getName());
                context.put("packageName", "org.jboss.hal.client.finder");
                context.put("className", COLUMN_MODULE_CLASS);
                context.put("columnInitClassName", COLUMN_INIT_CLASS);
                return context;
            });
            this.info("Successfully generated column initialization class [%s], [%s].", new Object[]{COLUMN_INIT_CLASS, COLUMN_MODULE_CLASS});
            this.columnInfos.clear();
        }
        return false;
    }

    private ColumnInfo columnInfo(TypeElement element, boolean async) {
        String id;
        String columnClass = element.getQualifiedName().toString();
        if (async) {
            AsyncColumn asyncColumn = element.getAnnotation(AsyncColumn.class);
            id = asyncColumn.value();
        } else {
            Column asyncColumn = element.getAnnotation(Column.class);
            id = asyncColumn.value();
        }
        return new ColumnInfo(columnClass, id, async);
    }

    public static final class ColumnInfo {
        private final String fqClassName;
        private final String id;
        private final boolean async;

        public ColumnInfo(String fqClassName, String id, boolean async) {
            this.fqClassName = fqClassName;
            this.id = id;
            this.async = async;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ColumnInfo)) {
                return false;
            }
            ColumnInfo that = (ColumnInfo)o;
            if (this.async != that.async) {
                return false;
            }
            return this.fqClassName.equals(that.fqClassName);
        }

        public int hashCode() {
            int result = this.fqClassName.hashCode();
            result = 31 * result + (this.async ? 1 : 0);
            return result;
        }

        public String toString() {
            return this.fqClassName;
        }

        public String getFqClassName() {
            return this.fqClassName;
        }

        public String getId() {
            return this.id;
        }

        public boolean isAsync() {
            return this.async;
        }
    }
}

