/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor.mbui;

import java.util.List;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import org.jboss.hal.processor.mbui.AbstractMbuiElementProcessor;
import org.jboss.hal.processor.mbui.Content;
import org.jboss.hal.processor.mbui.MbuiElementProcessor;
import org.jboss.hal.processor.mbui.MbuiViewContext;
import org.jboss.hal.processor.mbui.MbuiViewProcessor;
import org.jboss.hal.processor.mbui.VerticalNavigationInfo;
import org.jboss.hal.processor.mbui.XmlHelper;
import org.jdom2.Element;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

class VerticalNavigationProcessor
extends AbstractMbuiElementProcessor
implements MbuiElementProcessor {
    VerticalNavigationProcessor(MbuiViewProcessor processor, Elements elementUtils, XPathFactory xPathFactory) {
        super(processor, elementUtils, xPathFactory);
    }

    @Override
    public void process(VariableElement field, Element element, String selector, MbuiViewContext context) {
        VerticalNavigationInfo navigationInfo = new VerticalNavigationInfo(field.getSimpleName().toString(), selector);
        context.setVerticalNavigation(navigationInfo);
        XPathExpression expression = this.xPathFactory.compile("item", Filters.element());
        expression.evaluate((Object)element).forEach(itemElement -> navigationInfo.addItem(this.createItem(field, (Element)itemElement, context, 0)));
    }

    private VerticalNavigationInfo.Item createItem(VariableElement field, Element element, MbuiViewContext context, int level) {
        String id = element.getAttributeValue("id");
        String title = element.getAttributeValue("title");
        String icon = element.getAttributeValue("icon");
        if (id == null) {
            this.processor.error(field, "Invalid item \"%s\" in vertical-navigation: id is mandatory.", new Object[]{XmlHelper.xmlAsString(element)});
        }
        if (title == null) {
            this.processor.error(field, "Invalid item \"%s\" in vertical-navigation: title is mandatory.", new Object[]{XmlHelper.xmlAsString(element)});
        }
        VerticalNavigationInfo.Item item = new VerticalNavigationInfo.Item(id, title, icon);
        List subItems = element.getChildren("sub-item");
        if (!subItems.isEmpty()) {
            if (level > 0) {
                this.processor.error(field, "Invalid nesting in vertical-navigation: sub items cannot have nested sub items.", new Object[0]);
            }
            subItems.forEach(subItemElement -> item.addSubItem(this.createItem(field, (Element)subItemElement, context, level + 1)));
        } else {
            Content.parse(element, context).forEach(item::addContent);
        }
        return item;
    }
}

