/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor.mbui;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jboss.hal.ballroom.LabelBuilder;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.processor.mbui.AbstractMbuiElementProcessor;
import org.jboss.hal.processor.mbui.DataTableInfo;
import org.jboss.hal.processor.mbui.Handlebars;
import org.jboss.hal.processor.mbui.MbuiElementProcessor;
import org.jboss.hal.processor.mbui.MbuiViewContext;
import org.jboss.hal.processor.mbui.MbuiViewProcessor;
import org.jboss.hal.processor.mbui.MetadataInfo;
import org.jboss.hal.processor.mbui.XmlHelper;
import org.jdom2.Element;
import org.jdom2.xpath.XPathFactory;

class DataTableProcessor
extends AbstractMbuiElementProcessor
implements MbuiElementProcessor {
    DataTableProcessor(MbuiViewProcessor processor, Types typeUtils, Elements elementUtils, XPathFactory xPathFactory) {
        super(processor, typeUtils, elementUtils, xPathFactory);
    }

    @Override
    public void process(VariableElement field, Element element, String selector, MbuiViewContext context) {
        Element columnsContainer;
        MetadataInfo metadata = this.findMetadata(field, element, context);
        AddressTemplate template = AddressTemplate.of((String)metadata.getTemplate());
        String title = element.getAttributeValue("title");
        if (title == null) {
            title = new LabelBuilder().label(template.lastName());
        }
        DataTableInfo tableInfo = new DataTableInfo(field.getSimpleName().toString(), selector, this.getTypeParameter(field), metadata, title);
        context.addDataTableInfo(tableInfo);
        Element actionsContainer = element.getChild("actions");
        if (actionsContainer != null) {
            for (Element actionElement : actionsContainer.getChildren("action")) {
                String handler = actionElement.getAttributeValue("handler");
                String handlerRef = actionElement.getAttributeValue("handler-ref");
                String actionTitle = actionElement.getAttributeValue("title");
                String scope = actionElement.getAttributeValue("scope");
                String constraint = actionElement.getAttributeValue("constraint");
                String nameResolver = actionElement.getAttributeValue("name-resolver");
                Element attributesContainer = actionElement.getChild("attributes");
                if (handler != null && handlerRef != null) {
                    this.processor.error(field, "Multiple handlers specified for table#%s. Please specify only one of \"handler\" or \"handler-ref\".", new Object[]{selector});
                }
                if (handler != null) {
                    if (!Handlebars.isExpression(handler)) {
                        this.processor.error(field, "Invalid handler \"%s\" in data-table#%s: handler has to be an expression.", new Object[]{handler, selector});
                    }
                    if (actionTitle == null) {
                        this.processor.error(field, "Invalid handler \"%s\" in data-table#%s: Title is mandatory.", new Object[]{handler, selector});
                    }
                }
                if (handlerRef != null && DataTableInfo.HandlerRef.referenceFor(handlerRef) == null) {
                    String knownHandlerRefs = Stream.of(DataTableInfo.HandlerRef.values()).map(DataTableInfo.HandlerRef::getRef).collect(Collectors.joining(", "));
                    this.processor.error(field, "Unknown handler-ref \"%s\" in data-table#%s: Please choose one of %s.", new Object[]{handlerRef, selector, knownHandlerRefs});
                }
                if (!DataTableInfo.HandlerRef.ADD_RESOURCE.getRef().equals(handlerRef) && attributesContainer != null) {
                    this.processor.warning(field, "Attributes specified for handler-ref \"%s\" in data-table#%s: Attributes are only processed for \"%s\".", new Object[]{handlerRef, selector, DataTableInfo.HandlerRef.ADD_RESOURCE.name()});
                }
                if (nameResolver != null && !Handlebars.isExpression(nameResolver)) {
                    this.processor.error(field, "Name resolver in data-table#%s has to be an expression.", new Object[]{selector});
                }
                if (DataTableInfo.HandlerRef.REMOVE_RESOURCE.getRef().equals(handlerRef) && "*".equals(template.lastValue()) && nameResolver == null) {
                    this.processor.error(field, "\"%s\" handler-ref specified for data-table#%s and related metadata address ends in \"*\", but no name resolver is is provided.", new Object[]{DataTableInfo.HandlerRef.REMOVE_RESOURCE.getRef(), selector});
                }
                if (scope != null && !"selected".equals(scope)) {
                    this.processor.error(field, "Unknown scope \"%s\" in handler-ref \"%s\" in data-table#%s: Only \"selected\" is supported.", new Object[]{scope, handlerRef, selector});
                }
                if (constraint != null) {
                    if ("add".equals(constraint)) {
                        constraint = Constraint.executable((AddressTemplate)AddressTemplate.of((String)metadata.getTemplate()), (String)"add").data();
                    } else if ("remove".equals(constraint)) {
                        constraint = Constraint.executable((AddressTemplate)AddressTemplate.of((String)metadata.getTemplate()), (String)"remove").data();
                    }
                }
                DataTableInfo.Action action = new DataTableInfo.Action(handlerRef != null ? handlerRef : handler, actionTitle, scope, constraint, nameResolver);
                tableInfo.addAction(action);
                if (attributesContainer == null) continue;
                this.processAttributes(field, attributesContainer).forEach(action::addAttribute);
            }
        }
        if ((columnsContainer = element.getChild("columns")) != null) {
            for (Element columnElement : columnsContainer.getChildren("column")) {
                String name = columnElement.getAttributeValue("name");
                String value = columnElement.getAttributeValue("value");
                if (name == null) {
                    this.processor.error(field, "Invalid column \"%s\" in data-table#%s: name is mandatory.", new Object[]{XmlHelper.xmlAsString(columnElement), selector});
                }
                if (value != null && !Handlebars.isExpression(value)) {
                    this.processor.error(field, "Invalid column \"%s\" in data-table#%s: value has to be an expression.", new Object[]{XmlHelper.xmlAsString(columnElement), selector});
                }
                DataTableInfo.Column column = new DataTableInfo.Column(name, value);
                tableInfo.addColumn(column);
            }
        }
    }
}

