/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor.mbui;

import java.util.ArrayList;
import java.util.List;

public class TabsInfo {
    private static int counter = 0;
    private String name;
    private List<TabItem> items = new ArrayList<TabItem>();

    TabsInfo() {
        this.name = "tabs" + counter;
        ++counter;
    }

    public String getName() {
        return this.name;
    }

    public List<TabItem> getItems() {
        return this.items;
    }

    void addItem(TabItem item) {
        this.items.add(item);
    }

    public String toString() {
        StringBuilder tostr = new StringBuilder();
        tostr.append("TabsInfo { name = ").append(this.name).append(", items=");
        for (TabItem item : this.items) {
            tostr.append(item);
        }
        tostr.append(" }");
        return tostr.toString();
    }

    public static class TabItem {
        private String title;
        private String id;
        private List<String> formChildren = new ArrayList<String>();

        TabItem(String title, String id) {
            this.title = title;
            this.id = id;
        }

        public String getTitle() {
            return this.title;
        }

        public String getId() {
            return this.id;
        }

        public List<String> getFormChildren() {
            return this.formChildren;
        }

        void addChildId(String name) {
            this.formChildren.add(name);
        }

        public String toString() {
            StringBuilder tostr = new StringBuilder();
            tostr.append("TabItem { id = ").append(this.id).append(", title=").append(this.title).append(", formChildren=");
            for (int i = 0; i < this.formChildren.size(); ++i) {
                String child = this.formChildren.get(i);
                tostr.append(child);
                if (i + 1 >= this.formChildren.size()) continue;
                tostr.append(", ");
            }
            tostr.append(" }");
            return tostr.toString();
        }
    }
}

