/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor.mbui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.hal.processor.mbui.AbstractPropertyInfo;
import org.jboss.hal.processor.mbui.Content;
import org.jboss.hal.processor.mbui.DataTableInfo;
import org.jboss.hal.processor.mbui.FormInfo;
import org.jboss.hal.processor.mbui.MbuiElementInfo;
import org.jboss.hal.processor.mbui.MetadataInfo;
import org.jboss.hal.processor.mbui.PostConstructInfo;
import org.jboss.hal.processor.mbui.TabsInfo;
import org.jboss.hal.processor.mbui.VerticalNavigationInfo;

public class MbuiViewContext {
    private final String pkg;
    private final String base;
    private final String subclass;
    private final String createMethod;
    private VerticalNavigationInfo verticalNavigation;
    private final List<Content> content;
    private final Map<String, MetadataInfo> metadataInfos;
    private final Map<String, MbuiElementInfo> elements;
    private final List<DataTableInfo> dataTables;
    private final List<FormInfo> forms;
    private final List<MbuiElementInfo> attachables;
    private final List<AbstractPropertyInfo> abstractProperties;
    private final List<PostConstructInfo> postConstructs;
    private final List<TabsInfo> tabs;

    public MbuiViewContext(String pkg, String base, String subclass, String createMethod) {
        this.pkg = pkg;
        this.base = base;
        this.subclass = subclass;
        this.createMethod = createMethod;
        this.verticalNavigation = null;
        this.content = new ArrayList<Content>();
        this.metadataInfos = new HashMap<String, MetadataInfo>();
        this.elements = new HashMap<String, MbuiElementInfo>();
        this.dataTables = new ArrayList<DataTableInfo>();
        this.forms = new ArrayList<FormInfo>();
        this.attachables = new ArrayList<MbuiElementInfo>();
        this.abstractProperties = new ArrayList<AbstractPropertyInfo>();
        this.postConstructs = new ArrayList<PostConstructInfo>();
        this.tabs = new ArrayList<TabsInfo>();
    }

    public String toString() {
        return this.pkg + "." + this.subclass + " extends " + this.base;
    }

    public String getBase() {
        return this.base;
    }

    public String getPackage() {
        return this.pkg;
    }

    public String getCreateMethod() {
        return this.createMethod;
    }

    public String getSubclass() {
        return this.subclass;
    }

    public VerticalNavigationInfo getVerticalNavigation() {
        return this.verticalNavigation;
    }

    void setVerticalNavigation(VerticalNavigationInfo verticalNavigation) {
        this.verticalNavigation = verticalNavigation;
        this.elements.put(verticalNavigation.getSelector(), verticalNavigation);
    }

    public List<Content> getContent() {
        return this.content;
    }

    void addContent(Content content) {
        this.content.add(content);
    }

    Content findContent(String id) {
        for (Content c : this.content) {
            if (!id.equals(c.getReference())) continue;
            return c;
        }
        return null;
    }

    MetadataInfo getMetadataInfo(String address) {
        return this.metadataInfos.get(address);
    }

    public Collection<MetadataInfo> getMetadataInfos() {
        return this.metadataInfos.values();
    }

    void addMetadata(String address) {
        this.metadataInfos.computeIfAbsent(address, MetadataInfo::new);
    }

    <T extends MbuiElementInfo> T getElement(String selector) {
        return (T)this.elements.get(selector);
    }

    Collection<MbuiElementInfo> getElements() {
        return this.elements.values();
    }

    public List<DataTableInfo> getDataTables() {
        return this.dataTables;
    }

    void addDataTableInfo(DataTableInfo dataTableInfo) {
        this.dataTables.add(dataTableInfo);
        this.attachables.add(dataTableInfo);
        this.elements.put(dataTableInfo.getSelector(), dataTableInfo);
    }

    public List<FormInfo> getForms() {
        return this.forms;
    }

    void addFormInfo(FormInfo formInfo) {
        this.forms.add(formInfo);
        this.attachables.add(formInfo);
        this.elements.put(formInfo.getSelector(), formInfo);
    }

    public List<MbuiElementInfo> getAttachables() {
        return this.attachables;
    }

    public List<AbstractPropertyInfo> getAbstractProperties() {
        return this.abstractProperties;
    }

    void addAbstractProperty(AbstractPropertyInfo abstractPropertyInfo) {
        this.abstractProperties.add(abstractPropertyInfo);
    }

    public List<PostConstructInfo> getPostConstructs() {
        return this.postConstructs;
    }

    void addPostConstruct(PostConstructInfo postConstructInfo) {
        this.postConstructs.add(postConstructInfo);
    }

    public boolean hasTabs() {
        return this.tabs.size() > 0;
    }

    public List<TabsInfo> getTabs() {
        return this.tabs;
    }

    void addTab(TabsInfo tab) {
        this.tabs.add(tab);
    }

    public String findFormById(String id) {
        String found = null;
        for (FormInfo form : this.forms) {
            if (!form.getSelector().equals(id)) continue;
            found = form.getName();
            break;
        }
        return found;
    }

    public String findTabNameByTabId(String tabId) {
        String found = null;
        block0: for (TabsInfo tabsInfo : this.tabs) {
            for (TabsInfo.TabItem tabItem : tabsInfo.getItems()) {
                if (!tabItem.getId().equals(tabId)) continue;
                found = tabsInfo.getName();
                break block0;
            }
        }
        return found;
    }
}

