/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor.mbui;

import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.hal.processor.mbui.Handlebars;
import org.jboss.hal.processor.mbui.MbuiViewContext;
import org.jboss.hal.processor.mbui.MetadataInfo;
import org.jboss.hal.processor.mbui.XmlHelper;
import org.jdom2.Element;

public class Content {
    private static final Escaper JAVA_STRING_ESCAPER = Escapers.builder().addEscape('\"', "\\\"").addEscape('\n', "").addEscape('\r', "").build();
    private static int counter = 0;
    private String reference;
    private final String name;
    private final String html;
    private final Map<String, String> handlebars;

    static List<Content> parse(Element element, MbuiViewContext context) {
        ArrayList<Content> content = new ArrayList<Content>();
        MetadataInfo metadataInfo = null;
        Element contentElement = element;
        if (element.getChild("metadata") != null) {
            contentElement = element.getChild("metadata");
            metadataInfo = context.getMetadataInfo(contentElement.getAttributeValue("address"));
        }
        StringBuilder htmlBuilder = new StringBuilder();
        for (Element childElement : contentElement.getChildren()) {
            if ("table".equals(childElement.getName()) || "form".equals(childElement.getName())) {
                if (htmlBuilder.length() != 0) {
                    String html = htmlBuilder.toString();
                    htmlBuilder.setLength(0);
                    if (metadataInfo != null) {
                        html = html.replace("metadata", metadataInfo.getName());
                    }
                    content.add(new Content(null, html));
                }
                content.add(new Content(childElement.getAttributeValue("id"), null));
                continue;
            }
            htmlBuilder.append(JAVA_STRING_ESCAPER.escape(XmlHelper.xmlAsString(childElement)));
        }
        return content;
    }

    private Content(String reference, String html) {
        this.reference = reference;
        this.name = "html" + counter;
        this.html = html;
        this.handlebars = Handlebars.parse(html);
        ++counter;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getName() {
        return this.name;
    }

    public String getHtml() {
        return this.html;
    }

    public Map<String, String> getHandlebars() {
        return this.handlebars;
    }
}

