/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor.mbui;

import com.google.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.jboss.hal.processor.mbui.Attribute;
import org.jboss.hal.processor.mbui.Handlebars;
import org.jboss.hal.processor.mbui.MbuiElementProcessor;
import org.jboss.hal.processor.mbui.MbuiViewContext;
import org.jboss.hal.processor.mbui.MbuiViewProcessor;
import org.jboss.hal.processor.mbui.MetadataInfo;
import org.jboss.hal.processor.mbui.XmlHelper;
import org.jdom2.Element;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

abstract class AbstractMbuiElementProcessor
implements MbuiElementProcessor {
    private final Types typeUtils;
    final MbuiViewProcessor processor;
    final XPathFactory xPathFactory;

    AbstractMbuiElementProcessor(MbuiViewProcessor processor, Types typeUtils, XPathFactory xPathFactory) {
        this.processor = processor;
        this.typeUtils = typeUtils;
        this.xPathFactory = xPathFactory;
    }

    MetadataInfo findMetadata(VariableElement field, Element element, MbuiViewContext context) {
        MetadataInfo metadataInfo = null;
        XPathExpression expression = this.xPathFactory.compile("ancestor::metadata", Filters.element());
        Element metadataElement = (Element)expression.evaluateFirst((Object)element);
        if (metadataElement == null) {
            this.processor.error(field, "Missing metadata ancestor for %s#%s. Please make sure the there's a <%s/> ancestor element.", new Object[]{element.getName(), element.getAttributeValue("id"), "metadata"});
        } else {
            metadataInfo = context.getMetadataInfo(metadataElement.getAttributeValue("address"));
            if (metadataInfo == null) {
                this.processor.error(field, "No metadata found for %s#%s. Please make sure there's a <%s/> ancestor element.", new Object[]{element.getName(), element.getAttributeValue("id"), "metadata"});
            }
        }
        return metadataInfo;
    }

    String getTypeParameter(VariableElement field) {
        String typeArgument = "org.jboss.hal.dmr.ModelNode";
        DeclaredType declaredType = MoreTypes.asDeclared((TypeMirror)field.asType());
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (!typeArguments.isEmpty()) {
            typeArgument = MoreTypes.asTypeElement((Types)this.typeUtils, (TypeMirror)typeArguments.get(0)).getQualifiedName().toString();
        }
        return typeArgument;
    }

    List<Attribute> processAttributes(VariableElement field, Element attributesContainer) {
        int position = 0;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (Element attributeElement : attributesContainer.getChildren("attribute")) {
            Element templatesContainer;
            String name = attributeElement.getAttributeValue("name");
            String provider = attributeElement.getAttributeValue("provider");
            String validationHandler = attributeElement.getAttributeValue("validation-handler");
            String suggestHandlerAttribute = attributeElement.getAttributeValue("suggest-handler");
            Element suggestHandlerElement = attributeElement.getChild("suggest-handler");
            if (name == null) {
                this.processor.error(field, "Invalid attribute \"%s\": name is mandatory.", new Object[]{XmlHelper.xmlAsString(attributeElement)});
            }
            if (provider != null && !Handlebars.isExpression(provider)) {
                this.processor.error(field, "Provider for attribute \"%s\" has to be an expression.", new Object[]{XmlHelper.xmlAsString(attributeElement)});
            }
            if (validationHandler != null && !Handlebars.isExpression(validationHandler)) {
                this.processor.error(field, "Validation handler for attribute \"%s\" has to be an expression.", new Object[]{XmlHelper.xmlAsString(attributeElement)});
            }
            if (suggestHandlerAttribute != null && !Handlebars.isExpression(suggestHandlerAttribute)) {
                this.processor.error(field, "Suggestion handler for attribute \"%s\" has to be an expression.", new Object[]{XmlHelper.xmlAsString(attributeElement)});
            }
            if (suggestHandlerAttribute != null && suggestHandlerElement != null) {
                this.processor.error(field, "Invalid suggest handler for attribute \"%s\": Please specify suggest handler as attribute or child element, not both", new Object[]{XmlHelper.xmlAsString(attributeElement)});
            }
            Attribute attribute = new Attribute(name, provider, validationHandler, suggestHandlerAttribute, position);
            if (suggestHandlerElement != null && (templatesContainer = suggestHandlerElement.getChild("templates")) != null) {
                for (Element templateElement : templatesContainer.getChildren("template")) {
                    String address = templateElement.getAttributeValue("address");
                    attribute.addSuggestHandlerTemplate(address);
                }
            }
            attributes.add(attribute);
            ++position;
        }
        return attributes;
    }
}

