/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.processor.mbui;

import java.util.ArrayList;
import java.util.List;
import org.jboss.hal.processor.mbui.Handlebars;

public class Attribute {
    private final String name;
    private final String provider;
    private final String validationHandler;
    private final String suggestHandler;
    private final int position;
    private final List<String> suggestHandlerTemplates;

    Attribute(String name, String provider, String validationHandler, String suggestHandler, int position) {
        this.name = name;
        this.provider = Handlebars.stripHandlebar(provider);
        this.validationHandler = Handlebars.stripHandlebar(validationHandler);
        this.suggestHandler = Handlebars.stripHandlebar(suggestHandler);
        this.position = position;
        this.suggestHandlerTemplates = new ArrayList<String>();
    }

    public String getName() {
        return this.name;
    }

    public String getProvider() {
        return this.provider;
    }

    public int getPosition() {
        return this.position;
    }

    public String getValidationHandler() {
        return this.validationHandler;
    }

    public String getSuggestHandler() {
        return this.suggestHandler;
    }

    public List<String> getSuggestHandlerTemplates() {
        return this.suggestHandlerTemplates;
    }

    void addSuggestHandlerTemplate(String template) {
        this.suggestHandlerTemplates.add(template);
    }
}

