package org.jboss.hal.core.runtime.server;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.HandlerRegistration;

import com.google.gwt.event.shared.HasHandlers;

public class ServerResultEvent extends GwtEvent<ServerResultEvent.ServerResultHandler> { 

  org.jboss.hal.core.runtime.server.Server server;
  org.jboss.hal.flow.FlowStatus status;

  protected ServerResultEvent() {
    // Possibly for serialization.
  }

  public ServerResultEvent(org.jboss.hal.core.runtime.server.Server server, org.jboss.hal.flow.FlowStatus status) {
    this.server = server;
    this.status = status;
  }

  public static void fire(HasHandlers source, org.jboss.hal.core.runtime.server.Server server, org.jboss.hal.flow.FlowStatus status) {
    ServerResultEvent eventInstance = new ServerResultEvent(server, status);
    source.fireEvent(eventInstance);
  }

  public static void fire(HasHandlers source, ServerResultEvent eventInstance) {
    source.fireEvent(eventInstance);
  }

  public interface HasServerResultHandlers extends HasHandlers {
    HandlerRegistration addServerResultHandler(ServerResultHandler handler);
  }

  public interface ServerResultHandler extends EventHandler {
    public void onServerResult(ServerResultEvent event);
  }

  private static final Type<ServerResultHandler> TYPE = new Type<ServerResultHandler>();

  public static Type<ServerResultHandler> getType() {
    return TYPE;
  }

  @Override
  public Type<ServerResultHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(ServerResultHandler handler) {
    handler.onServerResult(this);
  }

  public org.jboss.hal.core.runtime.server.Server getServer(){
    return server;
  }

  public org.jboss.hal.flow.FlowStatus getStatus(){
    return status;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
        return true;
    if (obj == null)
        return false;
    if (getClass() != obj.getClass())
        return false;
    ServerResultEvent other = (ServerResultEvent) obj;
    if (server == null) {
      if (other.server != null)
        return false;
    } else if (!server.equals(other.server))
      return false;
    if (status == null) {
      if (other.status != null)
        return false;
    } else if (!status.equals(other.status))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    int hashCode = 23;
    hashCode = (hashCode * 37) + (server == null ? 1 : server.hashCode());
    hashCode = (hashCode * 37) + (status == null ? 1 : status.hashCode());
    return hashCode;
  }

  @Override
  public String toString() {
    return "ServerResultEvent["
                 + server
                 + ","
                 + status
    + "]";
  }
}
