package org.jboss.hal.core.header;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.HandlerRegistration;

import com.google.gwt.event.shared.HasHandlers;

public class HeaderModeEvent extends GwtEvent<HeaderModeEvent.HeaderModeHandler> { 

  org.jboss.hal.core.header.PresenterType presenterType;
  java.lang.String token;
  java.lang.String title;
  org.jboss.hal.dmr.ResourceAddress expertModeAddress;
  boolean backToNormalMode;
  boolean supportsExternal;
  boolean refreshable;

  public static class Builder { 
    // Required parameters
    private final org.jboss.hal.core.header.PresenterType presenterType;

    // Optional parameters - initialized to default values
    private java.lang.String token;
    private java.lang.String title;
    private org.jboss.hal.dmr.ResourceAddress expertModeAddress;
    private boolean backToNormalMode;
    private boolean supportsExternal;
    private boolean refreshable;

    public Builder(org.jboss.hal.core.header.PresenterType presenterType) {
      this.presenterType = presenterType;
    }

    public Builder token(java.lang.String token) {
      this.token = token;
      return this;
    }

    public Builder title(java.lang.String title) {
      this.title = title;
      return this;
    }

    public Builder expertModeAddress(org.jboss.hal.dmr.ResourceAddress expertModeAddress) {
      this.expertModeAddress = expertModeAddress;
      return this;
    }

    public Builder backToNormalMode(boolean backToNormalMode) {
      this.backToNormalMode = backToNormalMode;
      return this;
    }

    public Builder supportsExternal(boolean supportsExternal) {
      this.supportsExternal = supportsExternal;
      return this;
    }

    public Builder refreshable(boolean refreshable) {
      this.refreshable = refreshable;
      return this;
    }

    public HeaderModeEvent build() {
      return new HeaderModeEvent(this);
    }
  }

  public HeaderModeEvent(org.jboss.hal.core.header.PresenterType presenterType) {
    this.presenterType = presenterType;
  }

  private HeaderModeEvent(Builder builder) {
    this.presenterType = builder.presenterType;
    this.token = builder.token;
    this.title = builder.title;
    this.expertModeAddress = builder.expertModeAddress;
    this.backToNormalMode = builder.backToNormalMode;
    this.supportsExternal = builder.supportsExternal;
    this.refreshable = builder.refreshable;
  }

  public void fire(HasHandlers source) {
    source.fireEvent(this);
  }

  public static void fire(HasHandlers source, HeaderModeEvent eventInstance) {
    source.fireEvent(eventInstance);
  }

  public interface HasHeaderModeHandlers extends HasHandlers {
    HandlerRegistration addHeaderModeHandler(HeaderModeHandler handler);
  }

  public interface HeaderModeHandler extends EventHandler {
    public void onHeaderMode(HeaderModeEvent event);
  }

  private static final Type<HeaderModeHandler> TYPE = new Type<HeaderModeHandler>();

  public static Type<HeaderModeHandler> getType() {
    return TYPE;
  }

  @Override
  public Type<HeaderModeHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(HeaderModeHandler handler) {
    handler.onHeaderMode(this);
  }

  public org.jboss.hal.core.header.PresenterType getPresenterType(){
    return presenterType;
  }

  public java.lang.String getToken(){
    return token;
  }

  public java.lang.String getTitle(){
    return title;
  }

  public org.jboss.hal.dmr.ResourceAddress getExpertModeAddress(){
    return expertModeAddress;
  }

  public boolean isBackToNormalMode(){
    return backToNormalMode;
  }

  public boolean isSupportsExternal(){
    return supportsExternal;
  }

  public boolean isRefreshable(){
    return refreshable;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
        return true;
    if (obj == null)
        return false;
    if (getClass() != obj.getClass())
        return false;
    HeaderModeEvent other = (HeaderModeEvent) obj;
    if (presenterType == null) {
      if (other.presenterType != null)
        return false;
    } else if (!presenterType.equals(other.presenterType))
      return false;
    if (token == null) {
      if (other.token != null)
        return false;
    } else if (!token.equals(other.token))
      return false;
    if (title == null) {
      if (other.title != null)
        return false;
    } else if (!title.equals(other.title))
      return false;
    if (expertModeAddress == null) {
      if (other.expertModeAddress != null)
        return false;
    } else if (!expertModeAddress.equals(other.expertModeAddress))
      return false;
    if (backToNormalMode != other.backToNormalMode)
        return false;
    if (supportsExternal != other.supportsExternal)
        return false;
    if (refreshable != other.refreshable)
        return false;
    return true;
  }

  @Override
  public int hashCode() {
    int hashCode = 23;
    hashCode = (hashCode * 37) + (presenterType == null ? 1 : presenterType.hashCode());
    hashCode = (hashCode * 37) + (token == null ? 1 : token.hashCode());
    hashCode = (hashCode * 37) + (title == null ? 1 : title.hashCode());
    hashCode = (hashCode * 37) + (expertModeAddress == null ? 1 : expertModeAddress.hashCode());
    hashCode = (hashCode * 37) + new Boolean(backToNormalMode).hashCode();
    hashCode = (hashCode * 37) + new Boolean(supportsExternal).hashCode();
    hashCode = (hashCode * 37) + new Boolean(refreshable).hashCode();
    return hashCode;
  }

  @Override
  public String toString() {
    return "HeaderModeEvent["
                 + presenterType
                 + ","
                 + token
                 + ","
                 + title
                 + ","
                 + expertModeAddress
                 + ","
                 + backToNormalMode
                 + ","
                 + supportsExternal
                 + ","
                 + refreshable
    + "]";
  }
}
