package org.jboss.hal.client.runtime.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ServerView extends ServerView {

    private final Metadata metadata162;
    private final Metadata metadata163;
    private final Metadata metadata161;
    private final Metadata metadata165;
    private final Metadata metadata164;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ServerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata162Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/interface=*");
        this.metadata162 = mbuiContext.metadataRegistry().lookup(metadata162Template);
        AddressTemplate metadata163Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/jvm=*");
        this.metadata163 = mbuiContext.metadataRegistry().lookup(metadata163Template);
        AddressTemplate metadata161Template = AddressTemplate.of("/{selected.host}/{selected.server-config}");
        this.metadata161 = mbuiContext.metadataRegistry().lookup(metadata161Template);
        AddressTemplate metadata165Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/system-property=*");
        this.metadata165 = mbuiContext.metadataRegistry().lookup(metadata165Template);
        AddressTemplate metadata164Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/path=*");
        this.metadata164 = mbuiContext.metadataRegistry().lookup(metadata164Template);
        this.expressionElements = new HashMap<>();

        serverConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.server.Server>("server-configuration-form", metadata161)
            .includeRuntime()
            .include("name")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("host"), 1)
            .include("group")
            .include("auto-start")
            .include("update-auto-start-with-server-status")
            .include("socket-binding-group")
            .include("socket-binding-port-offset")
            .include("socket-binding-default-interface")
            .include("status")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Server Configuration", metadata161Template.resolve(statementContext()), changedValues, metadata161))
            .prepareReset(form -> resetSingletonForm("Server Configuration", metadata161Template.resolve(statementContext()), form, metadata161))
            .build();
        serverInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-interface-form", metadata162)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Interface", name, metadata162Template.resolve(statementContext(), name), changedValues, metadata162);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Interface", name, metadata162Template.resolve(statementContext(), name), form, metadata162);
            })
            .build();
        serverJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-jvm-form", metadata163)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JVM", name, metadata163Template.resolve(statementContext(), name), changedValues, metadata163);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("JVM", name, metadata163Template.resolve(statementContext(), name), form, metadata163);
            })
            .build();
        serverPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-path-form", metadata164)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata164Template.resolve(statementContext(), name), changedValues, metadata164);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Path", name, metadata164Template.resolve(statementContext(), name), form, metadata164);
            })
            .build();
        serverSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-system-property-form", metadata165)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata165Template.resolve(statementContext(), name), changedValues, metadata165);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata165Template.resolve(statementContext(), name), form, metadata165);
            })
            .build();

        serverInterfaceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-interface-table", metadata162)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-interface-table", Ids.ADD), "Interface",
                metadata162Template, asList("inet-address"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata162Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        serverJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-jvm-table", metadata163)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-jvm-table", Ids.ADD), "JVM",
                metadata163Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JVM", metadata163Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverPathTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-path-table", metadata164)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-path-table", Ids.ADD), "Path",
                metadata164Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata164Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        serverSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-system-property-table", metadata165)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-system-property-table", Ids.ADD), "System Property",
                metadata165Template, asList("value"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata165Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html482;
        HTMLElement serverConfigurationItemElement = section()
            .add(html482 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Configuration</h1><p>${metadata161.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverConfigurationForm)
                    .element();
        expressionElements.put("html482", html482);
        navigation.addPrimary("server-configuration-item", "Configuration", "pficon pficon-settings", serverConfigurationItemElement);
        HTMLElement html484;
        HTMLElement serverInterfaceItemElement = section()
            .add(html484 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>${metadata162.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverInterfaceTable)
            .add(serverInterfaceForm)
                    .element();
        expressionElements.put("html484", html484);
        navigation.addPrimary("server-interface-item", "Interfaces", "fa fa-exchange", serverInterfaceItemElement);
        HTMLElement html487;
        HTMLElement serverJvmItemElement = section()
            .add(html487 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>${metadata163.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverJvmTable)
            .add(serverJvmForm)
                    .element();
        expressionElements.put("html487", html487);
        navigation.addPrimary("server-jvm-item", "JVMs", "fa fa-coffee", serverJvmItemElement);
        HTMLElement html490;
        HTMLElement serverPathItemElement = section()
            .add(html490 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>${metadata164.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverPathTable)
            .add(serverPathForm)
                    .element();
        expressionElements.put("html490", html490);
        navigation.addPrimary("server-path-item", "Paths", "fa fa-folder-open", serverPathItemElement);
        HTMLElement html493;
        HTMLElement serverSystemPropertyItemElement = section()
            .add(html493 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>${metadata165.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverSystemPropertyTable)
            .add(serverSystemPropertyForm)
                    .element();
        expressionElements.put("html493", html493);
        navigation.addPrimary("server-system-property-item", "System Properties", "fa fa-list-ul", serverSystemPropertyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(serverConfigurationForm);
        registerAttachable(serverInterfaceTable);
        registerAttachable(serverInterfaceForm);
        registerAttachable(serverJvmTable);
        registerAttachable(serverJvmForm);
        registerAttachable(serverPathTable);
        registerAttachable(serverPathForm);
        registerAttachable(serverSystemPropertyTable);
        registerAttachable(serverSystemPropertyForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            serverInterfaceTable.bindForm(serverInterfaceForm);
            serverJvmTable.bindForm(serverJvmForm);
            serverPathTable.bindForm(serverPathForm);
            serverSystemPropertyTable.bindForm(serverSystemPropertyForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html482"), "${metadata161.getDescription().getDescription()}", String.valueOf(metadata161.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html484"), "${metadata162.getDescription().getDescription()}", String.valueOf(metadata162.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html487"), "${metadata163.getDescription().getDescription()}", String.valueOf(metadata163.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html490"), "${metadata164.getDescription().getDescription()}", String.valueOf(metadata164.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html493"), "${metadata165.getDescription().getDescription()}", String.valueOf(metadata165.getDescription().getDescription()));
    }
}
