package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_RemoteActiveMQView extends RemoteActiveMQView {

    private final Metadata metadata106;
    private final Metadata metadata103;
    private final Metadata metadata101;
    private final Metadata metadata108;
    private final Metadata metadata102;
    private final Metadata metadata105;
    private final Metadata metadata104;
    private final Metadata metadata100;
    private final Metadata metadata107;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_RemoteActiveMQView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata106Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/connection-factory=*");
        this.metadata106 = mbuiContext.metadataRegistry().lookup(metadata106Template);
        AddressTemplate metadata103Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/remote-connector=*");
        this.metadata103 = mbuiContext.metadataRegistry().lookup(metadata103Template);
        AddressTemplate metadata101Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/in-vm-connector=*");
        this.metadata101 = mbuiContext.metadataRegistry().lookup(metadata101Template);
        AddressTemplate metadata108Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/external-jms-topic=*");
        this.metadata108 = mbuiContext.metadataRegistry().lookup(metadata108Template);
        AddressTemplate metadata102Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/http-connector=*");
        this.metadata102 = mbuiContext.metadataRegistry().lookup(metadata102Template);
        AddressTemplate metadata105Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/socket-discovery-group=*");
        this.metadata105 = mbuiContext.metadataRegistry().lookup(metadata105Template);
        AddressTemplate metadata104Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/jgroups-discovery-group=*");
        this.metadata104 = mbuiContext.metadataRegistry().lookup(metadata104Template);
        AddressTemplate metadata100Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/connector=*");
        this.metadata100 = mbuiContext.metadataRegistry().lookup(metadata100Template);
        AddressTemplate metadata107Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/external-jms-queue=*");
        this.metadata107 = mbuiContext.metadataRegistry().lookup(metadata107Template);
        this.expressionElements = new HashMap<>();

        connectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-connector-form", metadata100)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.CONNECTOR, form))
            .build();
        inVmConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-in-vm-connector-form", metadata101)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.IN_VM_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.IN_VM_CONNECTOR, form))
            .build();
        httpConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-http-connector-form", metadata102)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.HTTP_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.HTTP_CONNECTOR, form))
            .build();
        remoteConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-remote-connector-form", metadata103)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.REMOTE_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.REMOTE_CONNECTOR, form))
            .build();
        socketDiscoveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-socket-discovery-group-form", metadata105)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.SOCKET_DISCOVERY_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.SOCKET_DISCOVERY_GROUP, form))
            .build();
        jgroupsDiscoveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-jgroups-discovery-group-form", metadata104)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.JGROUPS_DISCOVERY_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.JGROUPS_DISCOVERY_GROUP, form))
            .build();
        connectionFactoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-connection-factory-form", metadata106)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.CONNECTION_FACTORY, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.CONNECTION_FACTORY, form))
            .build();
        externalQueueForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-external-queue-form", metadata107)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.EXTERNAL_QUEUE, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.EXTERNAL_QUEUE, form))
            .build();
        externalTopicForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-external-topic-form", metadata108)
            .onSave((form, changedValues) -> presenter.save(RemoteActiveMQSubResource.EXTERNAL_TOPIC, form, changedValues))
            .prepareReset(form -> presenter.reset(RemoteActiveMQSubResource.EXTERNAL_TOPIC, form))
            .build();

        connectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-connector-table", metadata100)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        inVmConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-in-vm-connector-table", metadata101)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.IN_VM_CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/in-vm-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.IN_VM_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/in-vm-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("server-id")
            .build();
        httpConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-http-connector-table", metadata102)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addHttpConnector(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/http-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.HTTP_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/http-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-remote-connector-table", metadata103)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addRemoteConnector(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/remote-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.REMOTE_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/remote-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        socketDiscoveryGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-socket-discovery-group-table", metadata105)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.SOCKET_DISCOVERY_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/socket-discovery-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.SOCKET_DISCOVERY_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/socket-discovery-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        jgroupsDiscoveryGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-jgroups-discovery-group-table", metadata104)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.JGROUPS_DISCOVERY_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/jgroups-discovery-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.JGROUPS_DISCOVERY_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/jgroups-discovery-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectionFactoryTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-connection-factory-table", metadata106)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addConnectionFactory(RemoteActiveMQSubResource.CONNECTION_FACTORY), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/connection-factory=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.CONNECTION_FACTORY, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/connection-factory=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        externalQueueTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-external-queue-table", metadata107)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.EXTERNAL_QUEUE), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/external-jms-queue=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.EXTERNAL_QUEUE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/external-jms-queue=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        externalTopicTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("msg-remote-external-topic-table", metadata108)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(RemoteActiveMQSubResource.EXTERNAL_TOPIC), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/external-jms-topic=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(RemoteActiveMQSubResource.EXTERNAL_TOPIC, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/external-jms-topic=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        navigation.addPrimary("msg-remote-connector-group-item", "Connector", "fa fa-link");
        HTMLElement html292;
        HTMLElement msgRemoteConnectorItemElement = section()
            .add(html292 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Generic Connector</h1><p>${metadata100.getDescription().getDescription()}</p>"))
                                    .element())
            .add(connectorTable)
            .add(connectorForm)
                            .element();
        expressionElements.put("html292", html292);
        navigation.addSecondary("msg-remote-connector-group-item", "msg-remote-connector-item", "Generic", msgRemoteConnectorItemElement);
        HTMLElement html295;
        HTMLElement msgRemoteInVmConnectorItemElement = section()
            .add(html295 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In VM Connector</h1><p>${metadata101.getDescription().getDescription()}</p>"))
                                    .element())
            .add(inVmConnectorTable)
            .add(inVmConnectorForm)
                            .element();
        expressionElements.put("html295", html295);
        navigation.addSecondary("msg-remote-connector-group-item", "msg-remote-in-vm-connector-item", "In VM", msgRemoteInVmConnectorItemElement);
        HTMLElement html298;
        HTMLElement msgRemoteHttpConnectorItemElement = section()
            .add(html298 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Connector</h1><p>${metadata102.getDescription().getDescription()}</p>"))
                                    .element())
            .add(httpConnectorTable)
            .add(httpConnectorForm)
                            .element();
        expressionElements.put("html298", html298);
        navigation.addSecondary("msg-remote-connector-group-item", "msg-remote-http-connector-item", "HTTP", msgRemoteHttpConnectorItemElement);
        HTMLElement html301;
        HTMLElement msgRemoteRemoteConnectorItemElement = section()
            .add(html301 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Connector</h1><p>${metadata103.getDescription().getDescription()}</p>"))
                                    .element())
            .add(remoteConnectorTable)
            .add(remoteConnectorForm)
                            .element();
        expressionElements.put("html301", html301);
        navigation.addSecondary("msg-remote-connector-group-item", "msg-remote-remote-connector-item", "Remote", msgRemoteRemoteConnectorItemElement);
        navigation.addPrimary("msg-remote-discovery-group-item", "Discovery Group", "pficon pficon-service");
        HTMLElement html304;
        HTMLElement msgRemoteJgroupsDiscoveryGroupItemElement = section()
            .add(html304 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JGroups Discovery Group</h1><p>${metadata104.getDescription().getDescription()}</p>"))
                                    .element())
            .add(jgroupsDiscoveryGroupTable)
            .add(jgroupsDiscoveryGroupForm)
                            .element();
        expressionElements.put("html304", html304);
        navigation.addSecondary("msg-remote-discovery-group-item", "msg-remote-jgroups-discovery-group-item", "JGroups Discovery Group", msgRemoteJgroupsDiscoveryGroupItemElement);
        HTMLElement html307;
        HTMLElement msgRemoteSocketDiscoveryGroupItemElement = section()
            .add(html307 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Discovery Group</h1><p>${metadata105.getDescription().getDescription()}</p>"))
                                    .element())
            .add(socketDiscoveryGroupTable)
            .add(socketDiscoveryGroupForm)
                            .element();
        expressionElements.put("html307", html307);
        navigation.addSecondary("msg-remote-discovery-group-item", "msg-remote-socket-discovery-group-item", "Socket Discovery Group", msgRemoteSocketDiscoveryGroupItemElement);
        HTMLElement html310;
        HTMLElement msgRemoteConnectionFactoryItemElement = section()
            .add(html310 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connection Factory</h1><p>${metadata106.getDescription().getDescription()}</p>"))
                            .element())
            .add(connectionFactoryTable)
            .add(connectionFactoryForm)
                    .element();
        expressionElements.put("html310", html310);
        navigation.addPrimary("msg-remote-connection-factory-item", "Connection Factory", "fa fa-cubes", msgRemoteConnectionFactoryItemElement);
        HTMLElement html313;
        HTMLElement msgRemoteExternalQueueItemElement = section()
            .add(html313 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>External JMS Queue</h1><p>${metadata107.getDescription().getDescription()}</p>"))
                            .element())
            .add(externalQueueTable)
            .add(externalQueueForm)
                    .element();
        expressionElements.put("html313", html313);
        navigation.addPrimary("msg-remote-external-queue-item", "External JMS Queue", "fa fa-long-arrow-right", msgRemoteExternalQueueItemElement);
        HTMLElement html316;
        HTMLElement msgRemoteExternalTopicItemElement = section()
            .add(html316 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>External JMS Topic</h1><p>${metadata108.getDescription().getDescription()}</p>"))
                            .element())
            .add(externalTopicTable)
            .add(externalTopicForm)
                    .element();
        expressionElements.put("html316", html316);
        navigation.addPrimary("msg-remote-external-topic-item", "External JMS Topic", "fa fa-arrows", msgRemoteExternalTopicItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(connectorTable);
        registerAttachable(connectorForm);
        registerAttachable(inVmConnectorTable);
        registerAttachable(inVmConnectorForm);
        registerAttachable(httpConnectorTable);
        registerAttachable(httpConnectorForm);
        registerAttachable(remoteConnectorTable);
        registerAttachable(remoteConnectorForm);
        registerAttachable(socketDiscoveryGroupTable);
        registerAttachable(jgroupsDiscoveryGroupTable);
        registerAttachable(socketDiscoveryGroupForm);
        registerAttachable(jgroupsDiscoveryGroupForm);
        registerAttachable(connectionFactoryTable);
        registerAttachable(connectionFactoryForm);
        registerAttachable(externalQueueTable);
        registerAttachable(externalQueueForm);
        registerAttachable(externalTopicTable);
        registerAttachable(externalTopicForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            connectorTable.bindForm(connectorForm);
            inVmConnectorTable.bindForm(inVmConnectorForm);
            httpConnectorTable.bindForm(httpConnectorForm);
            remoteConnectorTable.bindForm(remoteConnectorForm);
            socketDiscoveryGroupTable.bindForm(socketDiscoveryGroupForm);
            jgroupsDiscoveryGroupTable.bindForm(jgroupsDiscoveryGroupForm);
            connectionFactoryTable.bindForm(connectionFactoryForm);
            externalQueueTable.bindForm(externalQueueForm);
            externalTopicTable.bindForm(externalTopicForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html292"), "${metadata100.getDescription().getDescription()}", String.valueOf(metadata100.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html295"), "${metadata101.getDescription().getDescription()}", String.valueOf(metadata101.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html298"), "${metadata102.getDescription().getDescription()}", String.valueOf(metadata102.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html301"), "${metadata103.getDescription().getDescription()}", String.valueOf(metadata103.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html304"), "${metadata104.getDescription().getDescription()}", String.valueOf(metadata104.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html307"), "${metadata105.getDescription().getDescription()}", String.valueOf(metadata105.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html310"), "${metadata106.getDescription().getDescription()}", String.valueOf(metadata106.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html313"), "${metadata107.getDescription().getDescription()}", String.valueOf(metadata107.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html316"), "${metadata108.getDescription().getDescription()}", String.valueOf(metadata108.getDescription().getDescription()));
    }
}
