package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ConnectionView extends ConnectionView {

    private final Metadata metadata93;
    private final Metadata metadata92;
    private final Metadata metadata90;
    private final Metadata metadata88;
    private final Metadata metadata85;
    private final Metadata metadata91;
    private final Metadata metadata89;
    private final Metadata metadata86;
    private final Metadata metadata87;
    private final Metadata metadata84;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ConnectionView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata93Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/connection-factory=*");
        this.metadata93 = mbuiContext.metadataRegistry().lookup(metadata93Template);
        AddressTemplate metadata92Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/connector-service=*");
        this.metadata92 = mbuiContext.metadataRegistry().lookup(metadata92Template);
        AddressTemplate metadata90Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/http-connector=*");
        this.metadata90 = mbuiContext.metadataRegistry().lookup(metadata90Template);
        AddressTemplate metadata88Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/connector=*");
        this.metadata88 = mbuiContext.metadataRegistry().lookup(metadata88Template);
        AddressTemplate metadata85Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/in-vm-acceptor=*");
        this.metadata85 = mbuiContext.metadataRegistry().lookup(metadata85Template);
        AddressTemplate metadata91Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/remote-connector=*");
        this.metadata91 = mbuiContext.metadataRegistry().lookup(metadata91Template);
        AddressTemplate metadata89Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/in-vm-connector=*");
        this.metadata89 = mbuiContext.metadataRegistry().lookup(metadata89Template);
        AddressTemplate metadata86Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*");
        this.metadata86 = mbuiContext.metadataRegistry().lookup(metadata86Template);
        AddressTemplate metadata87Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/remote-acceptor=*");
        this.metadata87 = mbuiContext.metadataRegistry().lookup(metadata87Template);
        AddressTemplate metadata84Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/acceptor=*");
        this.metadata84 = mbuiContext.metadataRegistry().lookup(metadata84Template);
        this.expressionElements = new HashMap<>();

        acceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-acceptor-form", metadata84)
            .include("factory-class", "socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.ACCEPTOR, form))
            .build();
        acceptorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        inVmAcceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-acceptor-form", metadata85)
            .include("server-id", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.IN_VM_ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.IN_VM_ACCEPTOR, form))
            .build();
        httpAcceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-acceptor-form", metadata86)
            .include("http-listener", "upgrade-legacy", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.HTTP_ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.HTTP_ACCEPTOR, form))
            .build();
        httpAcceptorForm.getFormItem("http-listener").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=undertow/server=*/http-listener=*")));
        remoteAcceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-acceptor-form", metadata87)
            .include("socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.REMOTE_ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.REMOTE_ACCEPTOR, form))
            .build();
        remoteAcceptorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        connectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-form", metadata88)
            .include("factory-class", "socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CONNECTOR, form))
            .build();
        connectorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        inVmConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-connector-form", metadata89)
            .include("server-id", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.IN_VM_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.IN_VM_CONNECTOR, form))
            .build();
        httpConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-connector-form", metadata90)
            .include("endpoint", "server-name", "socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.HTTP_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.HTTP_CONNECTOR, form))
            .build();
        httpConnectorForm.getFormItem("endpoint").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*")));
        httpConnectorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        remoteConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-connector-form", metadata91)
            .include("socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.REMOTE_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.REMOTE_CONNECTOR, form))
            .build();
        remoteConnectorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        connectorServiceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-service-form", metadata92)
            .include("factory-class", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CONNECTOR_SERVICE, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CONNECTOR_SERVICE, form))
            .build();
        connectionFactoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connection-factory-form", metadata93)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CONNECTION_FACTORY, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CONNECTION_FACTORY, form))
            .build();

        acceptorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-acceptor-table", metadata84)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.ACCEPTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/acceptor=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.ACCEPTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/acceptor=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        inVmAcceptorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-acceptor-table", metadata85)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.IN_VM_ACCEPTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-acceptor=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.IN_VM_ACCEPTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-acceptor=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("server-id")
            .build();
        httpAcceptorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-acceptor-table", metadata86)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addHttp(ServerSubResource.HTTP_ACCEPTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.HTTP_ACCEPTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteAcceptorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-acceptor-table", metadata87)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addRemote(ServerSubResource.REMOTE_ACCEPTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-acceptor=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.REMOTE_ACCEPTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-acceptor=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-table", metadata88)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        inVmConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-connector-table", metadata89)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.IN_VM_CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.IN_VM_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("server-id")
            .build();
        httpConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-connector-table", metadata90)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addHttpConnector(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.HTTP_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-connector-table", metadata91)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addRemote(ServerSubResource.REMOTE_CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.REMOTE_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectorServiceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-service-table", metadata92)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.CONNECTOR_SERVICE), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector-service=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CONNECTOR_SERVICE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector-service=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectionFactoryTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connection-factory-table", metadata93)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addConnectionFactory(ServerSubResource.CONNECTION_FACTORY), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connection-factory=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CONNECTION_FACTORY, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connection-factory=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        navigation.addPrimary("messaging-acceptor-group-item", "Acceptor", "fa fa-sign-in");
        HTMLElement html243;
        HTMLElement messagingAcceptorItemElement = section()
            .add(html243 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Generic Acceptor</h1><p>${metadata84.getDescription().getDescription()}</p>"))
                                    .element())
            .add(acceptorTable)
            .add(acceptorForm)
                            .element();
        expressionElements.put("html243", html243);
        navigation.addSecondary("messaging-acceptor-group-item", "messaging-acceptor-item", "Generic", messagingAcceptorItemElement);
        HTMLElement html246;
        HTMLElement messagingInVmAcceptorItemElement = section()
            .add(html246 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In VM Acceptor</h1><p>${metadata85.getDescription().getDescription()}</p>"))
                                    .element())
            .add(inVmAcceptorTable)
            .add(inVmAcceptorForm)
                            .element();
        expressionElements.put("html246", html246);
        navigation.addSecondary("messaging-acceptor-group-item", "messaging-in-vm-acceptor-item", "In VM", messagingInVmAcceptorItemElement);
        HTMLElement html249;
        HTMLElement messagingHttpAcceptorItemElement = section()
            .add(html249 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Acceptor</h1><p>${metadata86.getDescription().getDescription()}</p>"))
                                    .element())
            .add(httpAcceptorTable)
            .add(httpAcceptorForm)
                            .element();
        expressionElements.put("html249", html249);
        navigation.addSecondary("messaging-acceptor-group-item", "messaging-http-acceptor-item", "HTTP", messagingHttpAcceptorItemElement);
        HTMLElement html252;
        HTMLElement messagingRemoteAcceptorItemElement = section()
            .add(html252 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Acceptor</h1><p>${metadata87.getDescription().getDescription()}</p>"))
                                    .element())
            .add(remoteAcceptorTable)
            .add(remoteAcceptorForm)
                            .element();
        expressionElements.put("html252", html252);
        navigation.addSecondary("messaging-acceptor-group-item", "messaging-remote-acceptor-item", "Remote", messagingRemoteAcceptorItemElement);
        navigation.addPrimary("messaging-connector-group-item", "Connector", "fa fa-link");
        HTMLElement html255;
        HTMLElement messagingConnectorItemElement = section()
            .add(html255 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Generic Connector</h1><p>${metadata88.getDescription().getDescription()}</p>"))
                                    .element())
            .add(connectorTable)
            .add(connectorForm)
                            .element();
        expressionElements.put("html255", html255);
        navigation.addSecondary("messaging-connector-group-item", "messaging-connector-item", "Generic", messagingConnectorItemElement);
        HTMLElement html258;
        HTMLElement messagingInVmConnectorItemElement = section()
            .add(html258 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In VM Connector</h1><p>${metadata89.getDescription().getDescription()}</p>"))
                                    .element())
            .add(inVmConnectorTable)
            .add(inVmConnectorForm)
                            .element();
        expressionElements.put("html258", html258);
        navigation.addSecondary("messaging-connector-group-item", "messaging-in-vm-connector-item", "In VM", messagingInVmConnectorItemElement);
        HTMLElement html261;
        HTMLElement messagingHttpConnectorItemElement = section()
            .add(html261 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Connector</h1><p>${metadata90.getDescription().getDescription()}</p>"))
                                    .element())
            .add(httpConnectorTable)
            .add(httpConnectorForm)
                            .element();
        expressionElements.put("html261", html261);
        navigation.addSecondary("messaging-connector-group-item", "messaging-http-connector-item", "HTTP", messagingHttpConnectorItemElement);
        HTMLElement html264;
        HTMLElement messagingRemoteConnectorItemElement = section()
            .add(html264 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Connector</h1><p>${metadata91.getDescription().getDescription()}</p>"))
                                    .element())
            .add(remoteConnectorTable)
            .add(remoteConnectorForm)
                            .element();
        expressionElements.put("html264", html264);
        navigation.addSecondary("messaging-connector-group-item", "messaging-remote-connector-item", "Remote", messagingRemoteConnectorItemElement);
        HTMLElement html267;
        HTMLElement messagingConnectorServiceItemElement = section()
            .add(html267 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connector Service</h1><p>${metadata92.getDescription().getDescription()}</p>"))
                            .element())
            .add(connectorServiceTable)
            .add(connectorServiceForm)
                    .element();
        expressionElements.put("html267", html267);
        navigation.addPrimary("messaging-connector-service-item", "Connector Service", "pficon pficon-service", messagingConnectorServiceItemElement);
        HTMLElement html270;
        HTMLElement messagingConnectionFactoryItemElement = section()
            .add(html270 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connection Factory</h1><p>${metadata93.getDescription().getDescription()}</p>"))
                            .element())
            .add(connectionFactoryTable)
            .add(connectionFactoryForm)
                    .element();
        expressionElements.put("html270", html270);
        navigation.addPrimary("messaging-connection-factory-item", "Connection Factory", "fa fa-cubes", messagingConnectionFactoryItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(acceptorTable);
        registerAttachable(acceptorForm);
        registerAttachable(inVmAcceptorTable);
        registerAttachable(inVmAcceptorForm);
        registerAttachable(httpAcceptorTable);
        registerAttachable(httpAcceptorForm);
        registerAttachable(remoteAcceptorTable);
        registerAttachable(remoteAcceptorForm);
        registerAttachable(connectorTable);
        registerAttachable(connectorForm);
        registerAttachable(inVmConnectorTable);
        registerAttachable(inVmConnectorForm);
        registerAttachable(httpConnectorTable);
        registerAttachable(httpConnectorForm);
        registerAttachable(remoteConnectorTable);
        registerAttachable(remoteConnectorForm);
        registerAttachable(connectorServiceTable);
        registerAttachable(connectorServiceForm);
        registerAttachable(connectionFactoryTable);
        registerAttachable(connectionFactoryForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            acceptorTable.bindForm(acceptorForm);
            inVmAcceptorTable.bindForm(inVmAcceptorForm);
            httpAcceptorTable.bindForm(httpAcceptorForm);
            remoteAcceptorTable.bindForm(remoteAcceptorForm);
            connectorTable.bindForm(connectorForm);
            inVmConnectorTable.bindForm(inVmConnectorForm);
            httpConnectorTable.bindForm(httpConnectorForm);
            remoteConnectorTable.bindForm(remoteConnectorForm);
            connectorServiceTable.bindForm(connectorServiceForm);
            connectionFactoryTable.bindForm(connectionFactoryForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html243"), "${metadata84.getDescription().getDescription()}", String.valueOf(metadata84.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html246"), "${metadata85.getDescription().getDescription()}", String.valueOf(metadata85.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html249"), "${metadata86.getDescription().getDescription()}", String.valueOf(metadata86.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html252"), "${metadata87.getDescription().getDescription()}", String.valueOf(metadata87.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html255"), "${metadata88.getDescription().getDescription()}", String.valueOf(metadata88.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html258"), "${metadata89.getDescription().getDescription()}", String.valueOf(metadata89.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html261"), "${metadata90.getDescription().getDescription()}", String.valueOf(metadata90.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html264"), "${metadata91.getDescription().getDescription()}", String.valueOf(metadata91.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html267"), "${metadata92.getDescription().getDescription()}", String.valueOf(metadata92.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html270"), "${metadata93.getDescription().getDescription()}", String.valueOf(metadata93.getDescription().getDescription()));
    }
}
