package org.jboss.hal.client.runtime.host;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_HostView extends HostView {

    private final Metadata metadata59;
    private final Metadata metadata63;
    private final Metadata metadata61;
    private final Metadata metadata62;
    private final Metadata metadata60;
    private final Metadata metadata64;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_HostView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata59Template = AddressTemplate.of("/{selected.host}");
        this.metadata59 = mbuiContext.metadataRegistry().lookup(metadata59Template);
        AddressTemplate metadata63Template = AddressTemplate.of("/{selected.host}/socket-binding-group=*");
        this.metadata63 = mbuiContext.metadataRegistry().lookup(metadata63Template);
        AddressTemplate metadata61Template = AddressTemplate.of("/{selected.host}/jvm=*");
        this.metadata61 = mbuiContext.metadataRegistry().lookup(metadata61Template);
        AddressTemplate metadata62Template = AddressTemplate.of("/{selected.host}/path=*");
        this.metadata62 = mbuiContext.metadataRegistry().lookup(metadata62Template);
        AddressTemplate metadata60Template = AddressTemplate.of("/{selected.host}/interface=*");
        this.metadata60 = mbuiContext.metadataRegistry().lookup(metadata60Template);
        AddressTemplate metadata64Template = AddressTemplate.of("/{selected.host}/system-property=*");
        this.metadata64 = mbuiContext.metadataRegistry().lookup(metadata64Template);
        this.expressionElements = new HashMap<>();

        hostConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.host.Host>("host-configuration-form", metadata59)
            .includeRuntime()
            .include("name", "organization", "directory-grouping", "uuid", "release-codename", "release-version", "product-name", "product-version", "management-major-version", "management-minor-version", "management-micro-version", "running-mode", "host-state", "suspend-state")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveHost(form, changedValues))
            .prepareReset(form -> resetSingletonForm("Host Configuration", metadata59Template.resolve(statementContext()), form, metadata59))
            .build();
        hostInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-interface-form", metadata60)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Interface", name, metadata60Template.resolve(statementContext(), name), changedValues, metadata60);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Interface", name, metadata60Template.resolve(statementContext(), name), form, metadata60);
            })
            .build();
        hostJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-jvm-form", metadata61)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JVM", name, metadata61Template.resolve(statementContext(), name), changedValues, metadata61);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("JVM", name, metadata61Template.resolve(statementContext(), name), form, metadata61);
            })
            .build();
        hostPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-path-form", metadata62)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata62Template.resolve(statementContext(), name), changedValues, metadata62);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Path", name, metadata62Template.resolve(statementContext(), name), form, metadata62);
            })
            .build();
        hostSocketBindingGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-socket-binding-group-form", metadata63)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Socket Binding Group", name, metadata63Template.resolve(statementContext(), name), changedValues, metadata63);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Socket Binding Group", name, metadata63Template.resolve(statementContext(), name), form, metadata63);
            })
            .build();
        hostSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-system-property-form", metadata64)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata64Template.resolve(statementContext(), name), changedValues, metadata64);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata64Template.resolve(statementContext(), name), form, metadata64);
            })
            .build();

        hostInterfaceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-interface-table", metadata60)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-interface-table", Ids.ADD), "Interface",
                metadata60Template, asList("inet-address"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata60Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-jvm-table", metadata61)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-jvm-table", Ids.ADD), "JVM",
                metadata61Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JVM", metadata61Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        hostPathTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-path-table", metadata62)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-path-table", Ids.ADD), "Path",
                metadata62Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata62Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        hostSocketBindingGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-socket-binding-group-table", metadata63)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-socket-binding-group-table", Ids.ADD), "Socket Binding Group",
                metadata63Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Socket Binding Group", metadata63Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-system-property-table", metadata64)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-system-property-table", Ids.ADD), "System Property",
                metadata64Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata64Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html174;
        HTMLElement hostConfigurationItemElement = section()
            .add(html174 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"host-configuration-title\" /><p>${metadata59.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostConfigurationForm)
                    .element();
        expressionElements.put("html174", html174);
        navigation.addPrimary("host-configuration-item", "Configuration", "pficon pficon-settings", hostConfigurationItemElement);
        HTMLElement html176;
        HTMLElement hostInterfaceItemElement = section()
            .add(html176 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>${metadata60.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostInterfaceTable)
            .add(hostInterfaceForm)
                    .element();
        expressionElements.put("html176", html176);
        navigation.addPrimary("host-interface-item", "Interfaces", "fa fa-exchange", hostInterfaceItemElement);
        HTMLElement html179;
        HTMLElement hostJvmItemElement = section()
            .add(html179 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>${metadata61.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostJvmTable)
            .add(hostJvmForm)
                    .element();
        expressionElements.put("html179", html179);
        navigation.addPrimary("host-jvm-item", "JVMs", "fa fa-coffee", hostJvmItemElement);
        HTMLElement html182;
        HTMLElement hostPathItemElement = section()
            .add(html182 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>${metadata62.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostPathTable)
            .add(hostPathForm)
                    .element();
        expressionElements.put("html182", html182);
        navigation.addPrimary("host-path-item", "Paths", "fa fa-folder-open", hostPathItemElement);
        HTMLElement html185;
        HTMLElement hostSocketBindingGroupItemElement = section()
            .add(html185 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Binding Groups</h1><p>${metadata63.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostSocketBindingGroupTable)
            .add(hostSocketBindingGroupForm)
                    .element();
        expressionElements.put("html185", html185);
        navigation.addPrimary("host-socket-binding-group-item", "Socket Binding Groups", "fa fa-object-group", hostSocketBindingGroupItemElement);
        HTMLElement html188;
        HTMLElement hostSystemPropertyItemElement = section()
            .add(html188 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>${metadata64.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostSystemPropertyTable)
            .add(hostSystemPropertyForm)
                    .element();
        expressionElements.put("html188", html188);
        navigation.addPrimary("host-system-property-item", "System Properties", "fa fa-list-ul", hostSystemPropertyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(hostConfigurationForm);
        registerAttachable(hostInterfaceTable);
        registerAttachable(hostInterfaceForm);
        registerAttachable(hostJvmTable);
        registerAttachable(hostJvmForm);
        registerAttachable(hostPathTable);
        registerAttachable(hostPathForm);
        registerAttachable(hostSocketBindingGroupTable);
        registerAttachable(hostSocketBindingGroupForm);
        registerAttachable(hostSystemPropertyTable);
        registerAttachable(hostSystemPropertyForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            hostInterfaceTable.bindForm(hostInterfaceForm);
            hostJvmTable.bindForm(hostJvmForm);
            hostPathTable.bindForm(hostPathForm);
            hostSocketBindingGroupTable.bindForm(hostSocketBindingGroupForm);
            hostSystemPropertyTable.bindForm(hostSystemPropertyForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html174"), "${metadata59.getDescription().getDescription()}", String.valueOf(metadata59.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html176"), "${metadata60.getDescription().getDescription()}", String.valueOf(metadata60.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html179"), "${metadata61.getDescription().getDescription()}", String.valueOf(metadata61.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html182"), "${metadata62.getDescription().getDescription()}", String.valueOf(metadata62.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html185"), "${metadata63.getDescription().getDescription()}", String.valueOf(metadata63.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html188"), "${metadata64.getDescription().getDescription()}", String.valueOf(metadata64.getDescription().getDescription()));
    }
}
