package org.jboss.hal.client.configuration.subsystem.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_SecurityView extends SecurityView {

    private final Metadata metadata67;
    private final Metadata metadata70;
    private final Metadata metadata68;
    private final Metadata metadata66;
    private final Metadata metadata71;
    private final Metadata metadata69;
    private final Metadata metadata65;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_SecurityView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata67Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-store=*");
        this.metadata67 = mbuiContext.metadataRegistry().lookup(metadata67Template);
        AddressTemplate metadata70Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-store=*");
        this.metadata70 = mbuiContext.metadataRegistry().lookup(metadata70Template);
        AddressTemplate metadata68Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-realm=*");
        this.metadata68 = mbuiContext.metadataRegistry().lookup(metadata68Template);
        AddressTemplate metadata66Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-manager=*");
        this.metadata66 = mbuiContext.metadataRegistry().lookup(metadata66Template);
        AddressTemplate metadata71Template = AddressTemplate.of("/{selected.profile}/subsystem=security/vault=classic");
        this.metadata71 = mbuiContext.metadataRegistry().lookup(metadata71Template);
        AddressTemplate metadata69Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-manager=*");
        this.metadata69 = mbuiContext.metadataRegistry().lookup(metadata69Template);
        AddressTemplate metadata65Template = AddressTemplate.of("/{selected.profile}/subsystem=security");
        this.metadata65 = mbuiContext.metadataRegistry().lookup(metadata65Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-configuration-form", metadata65)
            .onSave((form, changedValues) -> saveSingletonForm("Configuration", metadata65Template.resolve(statementContext()), changedValues, metadata65))
            .prepareReset(form -> resetSingletonForm("Configuration", metadata65Template.resolve(statementContext()), form, metadata65))
            .build();
        keyManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-manager-form", metadata66)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Manager", name, metadata66Template.resolve(statementContext(), name), changedValues, metadata66);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Key Manager", name, metadata66Template.resolve(statementContext(), name), form, metadata66);
            })
            .build();
        keyStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-store-form", metadata67)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Store", name, metadata67Template.resolve(statementContext(), name), changedValues, metadata67);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Key Store", name, metadata67Template.resolve(statementContext(), name), form, metadata67);
            })
            .build();
        realmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-realm-form", metadata68)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Realm", name, metadata68Template.resolve(statementContext(), name), changedValues, metadata68);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Realm", name, metadata68Template.resolve(statementContext(), name), form, metadata68);
            })
            .build();
        trustManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-manager-form", metadata69)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Manager", name, metadata69Template.resolve(statementContext(), name), changedValues, metadata69);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Trust Manager", name, metadata69Template.resolve(statementContext(), name), form, metadata69);
            })
            .build();
        trustStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-store-form", metadata70)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Store", name, metadata70Template.resolve(statementContext(), name), changedValues, metadata70);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Trust Store", name, metadata70Template.resolve(statementContext(), name), form, metadata70);
            })
            .build();
        vaultForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-vault-form", metadata71)
            .singleton(
                () -> new Operation.Builder(metadata71Template.resolve(statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("security-vault-form", "Vault", metadata71Template))
            .prepareRemove(form -> removeSingletonForm("Vault", metadata71Template.resolve(statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Vault", metadata71Template.resolve(statementContext()), changedValues, metadata71))
            .prepareReset(form -> resetSingletonForm("Vault", metadata71Template.resolve(statementContext()), form, metadata71))
            .build();

        keyManagerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-manager-table", metadata66)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-manager-table", Ids.ADD), "Elytron Key Manager",
                metadata66Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Manager", metadata66Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        keyStoreTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-store-table", metadata67)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-store-table", Ids.ADD), "Elytron Key Store",
                metadata67Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Store", metadata67Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        realmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-realm-table", metadata68)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-realm-table", Ids.ADD), "Elytron Realm",
                metadata68Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Realm", metadata68Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jaas-config")
            .build();
        trustManagerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-manager-table", metadata69)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-manager-table", Ids.ADD), "Elytron Trust Manager",
                metadata69Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Manager", metadata69Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        trustStoreTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-store-table", metadata70)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-store-table", Ids.ADD), "Elytron Trust Store",
                metadata70Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Store", metadata70Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html192;
        HTMLElement securityConfigurationItemElement = section()
            .add(html192 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata65.getDescription().getDescription()}</p>"))
                            .element())
            .add(configurationForm)
                    .element();
        expressionElements.put("html192", html192);
        navigation.addPrimary("security-configuration-item", "Configuration", "pficon pficon-settings", securityConfigurationItemElement);
        HTMLElement html194;
        HTMLElement securityElytronKeyManagerItemElement = section()
            .add(html194 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Manager</h1><p>${metadata66.getDescription().getDescription()}</p>"))
                            .element())
            .add(keyManagerTable)
            .add(keyManagerForm)
                    .element();
        expressionElements.put("html194", html194);
        navigation.addPrimary("security-elytron-key-manager-item", "Key Manager", "fa fa-key", securityElytronKeyManagerItemElement);
        HTMLElement html197;
        HTMLElement securityElytronKeyStoreItemElement = section()
            .add(html197 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Store</h1><p>${metadata67.getDescription().getDescription()}</p>"))
                            .element())
            .add(keyStoreTable)
            .add(keyStoreForm)
                    .element();
        expressionElements.put("html197", html197);
        navigation.addPrimary("security-elytron-key-store-item", "Key Store", "fa fa-key", securityElytronKeyStoreItemElement);
        HTMLElement html200;
        HTMLElement securityElytronRealmItemElement = section()
            .add(html200 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Realm</h1><p>${metadata68.getDescription().getDescription()}</p>"))
                            .element())
            .add(realmTable)
            .add(realmForm)
                    .element();
        expressionElements.put("html200", html200);
        navigation.addPrimary("security-elytron-realm-item", "Realm", "fa fa-map", securityElytronRealmItemElement);
        HTMLElement html203;
        HTMLElement securityElytronTrustManagerItemElement = section()
            .add(html203 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Manager</h1><p>${metadata69.getDescription().getDescription()}</p>"))
                            .element())
            .add(trustManagerTable)
            .add(trustManagerForm)
                    .element();
        expressionElements.put("html203", html203);
        navigation.addPrimary("security-elytron-trust-manager-item", "Trust Manager", "fa fa-lock", securityElytronTrustManagerItemElement);
        HTMLElement html206;
        HTMLElement securityElytronTrustStoreItemElement = section()
            .add(html206 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Store</h1><p>${metadata70.getDescription().getDescription()}</p>"))
                            .element())
            .add(trustStoreTable)
            .add(trustStoreForm)
                    .element();
        expressionElements.put("html206", html206);
        navigation.addPrimary("security-elytron-trust-store-item", "Trust Store", "fa fa-lock", securityElytronTrustStoreItemElement);
        HTMLElement html209;
        HTMLElement securityVaultItemElement = section()
            .add(html209 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Vault</h1><p>${metadata71.getDescription().getDescription()}</p>"))
                            .element())
            .add(vaultForm)
                    .element();
        expressionElements.put("html209", html209);
        navigation.addPrimary("security-vault-item", "Vault", "fa fa-shield", securityVaultItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(keyManagerTable);
        registerAttachable(keyManagerForm);
        registerAttachable(keyStoreTable);
        registerAttachable(keyStoreForm);
        registerAttachable(realmTable);
        registerAttachable(realmForm);
        registerAttachable(trustManagerTable);
        registerAttachable(trustManagerForm);
        registerAttachable(trustStoreTable);
        registerAttachable(trustStoreForm);
        registerAttachable(vaultForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            keyManagerTable.bindForm(keyManagerForm);
            keyStoreTable.bindForm(keyStoreForm);
            realmTable.bindForm(realmForm);
            trustManagerTable.bindForm(trustManagerForm);
            trustStoreTable.bindForm(trustStoreForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html192"), "${metadata65.getDescription().getDescription()}", String.valueOf(metadata65.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html194"), "${metadata66.getDescription().getDescription()}", String.valueOf(metadata66.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html197"), "${metadata67.getDescription().getDescription()}", String.valueOf(metadata67.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html200"), "${metadata68.getDescription().getDescription()}", String.valueOf(metadata68.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html203"), "${metadata69.getDescription().getDescription()}", String.valueOf(metadata69.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html206"), "${metadata70.getDescription().getDescription()}", String.valueOf(metadata70.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html209"), "${metadata71.getDescription().getDescription()}", String.valueOf(metadata71.getDescription().getDescription()));
    }
}
