package org.jboss.hal.client.configuration.subsystem.logging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_LoggingView extends LoggingView {

    private final Metadata metadata35;
    private final Metadata metadata32;
    private final Metadata metadata31;
    private final Metadata metadata24;
    private final Metadata metadata34;
    private final Metadata metadata33;
    private final Metadata metadata37;
    private final Metadata metadata25;
    private final Metadata metadata28;
    private final Metadata metadata27;
    private final Metadata metadata26;
    private final Metadata metadata29;
    private final Metadata metadata30;
    private final Metadata metadata36;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_LoggingView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata35Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*");
        this.metadata35 = mbuiContext.metadataRegistry().lookup(metadata35Template);
        AddressTemplate metadata32Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*");
        this.metadata32 = mbuiContext.metadataRegistry().lookup(metadata32Template);
        AddressTemplate metadata31Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*");
        this.metadata31 = mbuiContext.metadataRegistry().lookup(metadata31Template);
        AddressTemplate metadata24Template = AddressTemplate.of("/{selected.profile}/subsystem=logging");
        this.metadata24 = mbuiContext.metadataRegistry().lookup(metadata24Template);
        AddressTemplate metadata34Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/socket-handler=*");
        this.metadata34 = mbuiContext.metadataRegistry().lookup(metadata34Template);
        AddressTemplate metadata33Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*");
        this.metadata33 = mbuiContext.metadataRegistry().lookup(metadata33Template);
        AddressTemplate metadata37Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*");
        this.metadata37 = mbuiContext.metadataRegistry().lookup(metadata37Template);
        AddressTemplate metadata25Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/root-logger=ROOT");
        this.metadata25 = mbuiContext.metadataRegistry().lookup(metadata25Template);
        AddressTemplate metadata28Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*");
        this.metadata28 = mbuiContext.metadataRegistry().lookup(metadata28Template);
        AddressTemplate metadata27Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*");
        this.metadata27 = mbuiContext.metadataRegistry().lookup(metadata27Template);
        AddressTemplate metadata26Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logger=*");
        this.metadata26 = mbuiContext.metadataRegistry().lookup(metadata26Template);
        AddressTemplate metadata29Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*");
        this.metadata29 = mbuiContext.metadataRegistry().lookup(metadata29Template);
        AddressTemplate metadata30Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*");
        this.metadata30 = mbuiContext.metadataRegistry().lookup(metadata30Template);
        AddressTemplate metadata36Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*");
        this.metadata36 = mbuiContext.metadataRegistry().lookup(metadata36Template);
        this.expressionElements = new HashMap<>();

        loggingConfigForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-config-form", metadata24)
            .onSave((form, changedValues) -> saveSingletonForm("Logging Configuration", metadata24Template.resolve(statementContext()), changedValues, metadata24))
            .prepareReset(form -> resetSingletonForm("Logging Configuration", metadata24Template.resolve(statementContext()), form, metadata24))
            .build();
        rootLoggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-root-logger-form", metadata25)
            .include("level", "handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Root Logger", metadata25Template.resolve(statementContext()), changedValues, metadata25))
            .prepareReset(form -> resetSingletonForm("Root Logger", metadata25Template.resolve(statementContext()), form, metadata25))
            .build();
        List<AddressTemplate> rootLoggerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/socket-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        rootLoggerForm.getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), rootLoggerFormTemplates));
        loggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-category-form", metadata26)
            .include("category", "filter-spec", "handlers", "level", "use-parent-handlers")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Category", name, metadata26Template.resolve(statementContext(), name), changedValues, metadata26);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Category", name, metadata26Template.resolve(statementContext(), name), form, metadata26);
            })
            .build();
        List<AddressTemplate> loggerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/socket-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        loggerForm.getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), loggerFormTemplates));
        consoleHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-console-form", metadata28)
            .include("autoflush", "enabled", "encoding", "filter-spec", "formatter", "level", "named-formatter", "target")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Console Handler", name, metadata28Template.resolve(statementContext(), name), changedValues, metadata28);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Console Handler", name, metadata28Template.resolve(statementContext(), name), form, metadata28);
            })
            .build();
        List<AddressTemplate> consoleHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        consoleHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), consoleHandlerFormTemplates));
        fileHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-file-form", metadata30)
            .include("append", "autoflush", "enabled", "encoding", "file.path", "file.relative-to", "filter-spec", "formatter", "level", "named-formatter")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("File Handler", name, metadata30Template.resolve(statementContext(), name), changedValues, metadata30);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("File Handler", name, metadata30Template.resolve(statementContext(), name), form, metadata30);
            })
            .build();
        fileHandlerForm.getFormItem("file.relative-to").registerSuggestHandler(new org.jboss.hal.core.configuration.PathsAutoComplete());
        List<AddressTemplate> fileHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        fileHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), fileHandlerFormTemplates));
        periodicHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-periodic-rotating-file-form", metadata31)
            .include("append", "autoflush", "enabled", "encoding", "file.path", "file.relative-to", "filter-spec", "formatter", "level", "named-formatter", "suffix")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Periodic Rotating File Handler", name, metadata31Template.resolve(statementContext(), name), changedValues, metadata31);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Periodic Rotating File Handler", name, metadata31Template.resolve(statementContext(), name), form, metadata31);
            })
            .build();
        periodicHandlerForm.getFormItem("file.relative-to").registerSuggestHandler(new org.jboss.hal.core.configuration.PathsAutoComplete());
        List<AddressTemplate> periodicHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        periodicHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), periodicHandlerFormTemplates));
        periodicSizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-periodic-size-rotating-file-form", metadata32)
            .include("append", "autoflush", "enabled", "encoding", "file.path", "file.relative-to", "filter-spec", "formatter", "level", "max-backup-index", "named-formatter", "rotate-size", "rotate-on-boot", "suffix")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Periodic Size Rotating File Handler", name, metadata32Template.resolve(statementContext(), name), changedValues, metadata32);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Periodic Size Rotating File Handler", name, metadata32Template.resolve(statementContext(), name), form, metadata32);
            })
            .build();
        periodicSizeHandlerForm.getFormItem("file.relative-to").registerSuggestHandler(new org.jboss.hal.core.configuration.PathsAutoComplete());
        List<AddressTemplate> periodicSizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        periodicSizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), periodicSizeHandlerFormTemplates));
        sizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-size-rotating-file-form", metadata33)
            .include("append", "autoflush", "enabled", "encoding", "file.path", "file.relative-to", "filter-spec", "formatter", "level", "max-backup-index", "named-formatter", "rotate-size", "rotate-on-boot", "suffix")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Size Rotating File Handler", name, metadata33Template.resolve(statementContext(), name), changedValues, metadata33);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Size Rotating File Handler", name, metadata33Template.resolve(statementContext(), name), form, metadata33);
            })
            .build();
        sizeHandlerForm.getFormItem("file.relative-to").registerSuggestHandler(new org.jboss.hal.core.configuration.PathsAutoComplete());
        List<AddressTemplate> sizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        sizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), sizeHandlerFormTemplates));
        asyncHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-async-form", metadata27)
            .include("filter-spec", "level", "overflow-action", "queue-length", "subhandlers")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Async Handler", name, metadata27Template.resolve(statementContext(), name), changedValues, metadata27);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Async Handler", name, metadata27Template.resolve(statementContext(), name), form, metadata27);
            })
            .build();
        List<AddressTemplate> asyncHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/socket-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        asyncHandlerForm.getFormItem("subhandlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), asyncHandlerFormTemplates));
        customHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-custom-form", metadata29)
            .include("class", "enabled", "encoding", "filter-spec", "formatter", "level", "module", "named-formatter", "properties")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Custom Handler", name, metadata29Template.resolve(statementContext(), name), changedValues, metadata29);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Custom Handler", name, metadata29Template.resolve(statementContext(), name), form, metadata29);
            })
            .build();
        List<AddressTemplate> customHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        customHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), customHandlerFormTemplates));
        socketHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-socket-form", metadata34)
            .include("autoflush", "block-on-reconnect", "enabled", "encoding", "filter-spec", "level", "named-formatter", "outbound-socket-binding-ref", "protocol", "ssl-context")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Socket Handler", name, metadata34Template.resolve(statementContext(), name), changedValues, metadata34);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Socket Handler", name, metadata34Template.resolve(statementContext(), name), form, metadata34);
            })
            .build();
        List<AddressTemplate> socketHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        socketHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), socketHandlerFormTemplates));
        syslogHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-syslog-form", metadata35)
            .include("app-name", "enabled", "facility", "hostname", "level", "named-formatter", "port", "server-address", "syslog-format")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Syslog Handler", name, metadata35Template.resolve(statementContext(), name), changedValues, metadata35);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Syslog Handler", name, metadata35Template.resolve(statementContext(), name), form, metadata35);
            })
            .build();
        List<AddressTemplate> syslogHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        syslogHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), statementContext(), syslogHandlerFormTemplates));
        customFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-formatter-custom-form", metadata36)
            .include("class", "module", "properties")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Custom Formatter", name, metadata36Template.resolve(statementContext(), name), changedValues, metadata36);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Custom Formatter", name, metadata36Template.resolve(statementContext(), name), form, metadata36);
            })
            .build();
        patternFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-formatter-pattern-form", metadata37)
            .include("color-map", "pattern")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Pattern Formatter", name, metadata37Template.resolve(statementContext(), name), changedValues, metadata37);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Pattern Formatter", name, metadata37Template.resolve(statementContext(), name), form, metadata37);
            })
            .build();

        loggerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-category-table", metadata26)
            .button(mbuiContext.tableButtonFactory().add(metadata26Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("logging-category-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Category"),
                    metadata26,
                    asList("level", "handlers", "use-parent-handlers"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata26Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Category", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                List<AddressTemplate> loggerTableTemplates = asList(
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/socket-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
                dialog.getForm().getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), statementContext(), loggerTableTemplates));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Category", metadata26Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("category", "level")
            .build();
        consoleHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-console-table", metadata28)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-handler-console-table", Ids.ADD), "Console Handler",
                metadata28Template, asList("level", "formatter", "target"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Console Handler", metadata28Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level", "target")
            .build();
        fileHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-file-table", metadata30)
            .button(mbuiContext.tableButtonFactory().add(metadata30Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("logging-handler-file-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("File Handler"),
                    metadata30,
                    asList("file.path", "file.relative-to", "formatter", "level"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata30Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("file.relative-to").registerSuggestHandler(new org.jboss.hal.core.configuration.PathsAutoComplete());
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("File Handler", metadata30Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-periodic-rotating-file-table", metadata31)
            .button(mbuiContext.tableButtonFactory().add(metadata31Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("logging-handler-periodic-rotating-file-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Periodic Rotating File Handler"),
                    metadata31,
                    asList("file.path", "file.relative-to", "formatter", "level", "suffix"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata31Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Periodic Rotating File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("file.relative-to").registerSuggestHandler(new org.jboss.hal.core.configuration.PathsAutoComplete());
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Periodic Rotating File Handler", metadata31Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicSizeHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-periodic-size-rotating-file-table", metadata32)
            .button(mbuiContext.tableButtonFactory().add(metadata32Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("logging-handler-periodic-size-rotating-file-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Periodic Size Rotating File Handler"),
                    metadata32,
                    asList("file.path", "file.relative-to", "formatter", "level", "max-backup-index", "rotate-size", "suffix"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata32Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Periodic Size Rotating File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("file.relative-to").registerSuggestHandler(new org.jboss.hal.core.configuration.PathsAutoComplete());
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Periodic Size Rotating File Handler", metadata32Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        sizeHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-size-rotating-file-table", metadata33)
            .button(mbuiContext.tableButtonFactory().add(metadata33Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("logging-handler-size-rotating-file-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Size Rotating File Handler"),
                    metadata33,
                    asList("file.path", "file.relative-to", "formatter", "level", "max-backup-index", "rotate-size", "suffix"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata33Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Size Rotating File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("file.relative-to").registerSuggestHandler(new org.jboss.hal.core.configuration.PathsAutoComplete());
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Size Rotating File Handler", metadata33Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        asyncHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-async-table", metadata27)
            .button(mbuiContext.tableButtonFactory().add(metadata27Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("logging-handler-async-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Async Handler"),
                    metadata27,
                    asList("level", "overflow-action", "queue-length", "subhandlers"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata27Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Async Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                List<AddressTemplate> asyncHandlerTableTemplates = asList(
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/socket-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
                dialog.getForm().getFormItem("subhandlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), statementContext(), asyncHandlerTableTemplates));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Async Handler", metadata27Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level")
            .build();
        customHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-custom-table", metadata29)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-handler-custom-table", Ids.ADD), "Custom Handler",
                metadata29Template, asList("class", "formatter", "level", "module"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Custom Handler", metadata29Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level")
            .build();
        socketHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-socket-table", metadata34)
            .button(mbuiContext.tableButtonFactory().add(metadata34Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("logging-handler-socket-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Socket Handler"),
                    metadata34,
                    asList("named-formatter", "outbound-socket-binding-ref"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata34Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Socket Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                List<AddressTemplate> socketHandlerTableTemplates = asList(
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
                dialog.getForm().getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), statementContext(), socketHandlerTableTemplates));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Socket Handler", metadata34Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("level")
            .build();
        syslogHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-syslog-table", metadata35)
            .button(mbuiContext.tableButtonFactory().add(metadata35Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("logging-handler-syslog-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Syslog Handler"),
                    metadata35,
                    asList("app-name", "facility", "hostname", "level", "named-formatter", "port", "server-address", "syslog-format"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata35Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Syslog Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                List<AddressTemplate> syslogHandlerTableTemplates = asList(
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
                dialog.getForm().getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), statementContext(), syslogHandlerTableTemplates));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Syslog Handler", metadata35Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("level")
            .build();
        customFormatterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-formatter-custom-table", metadata36)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-formatter-custom-table", Ids.ADD), "Custom Formatter",
                metadata36Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Custom Formatter", metadata36Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        patternFormatterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-formatter-pattern-table", metadata37)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-formatter-pattern-table", Ids.ADD), "Pattern Formatter",
                metadata37Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Pattern Formatter", metadata37Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("pattern")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html68;
        HTMLElement loggingConfigItemElement = section()
            .add(html68 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata24.getDescription().getDescription()}</p>"))
                            .element())
            .add(loggingConfigForm)
                    .element();
        expressionElements.put("html68", html68);
        navigation.addPrimary("logging-config-item", "Configuration", "pficon pficon-settings", loggingConfigItemElement);
        HTMLElement html70;
        HTMLElement loggingRootLoggerItemElement = section()
            .add(html70 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"logging-root-logger-header\">Root Logger</h1><p id=\"logging-root-logger-description\">${metadata25.getDescription().getDescription()}</p>"))
                            .element())
            .add(rootLoggerForm)
                    .element();
        expressionElements.put("html70", html70);
        navigation.addPrimary("logging-root-logger-item", "Root Logger", "fa fa-sitemap", loggingRootLoggerItemElement);
        HTMLElement html72;
        HTMLElement loggingCategoryItemElement = section()
            .add(html72 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Categories</h1><p>${metadata26.getDescription().getDescription()}</p>"))
                            .element())
            .add(loggerTable)
            .add(loggerForm)
                    .element();
        expressionElements.put("html72", html72);
        navigation.addPrimary("logging-category-item", "Categories", "pficon pficon-repository", loggingCategoryItemElement);
        navigation.addPrimary("logging-handler-item", "Handler", "fa fa-cogs");
        HTMLElement html75;
        HTMLElement loggingHandlerAsyncItemElement = section()
            .add(html75 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async Handler</h1><p>${metadata27.getDescription().getDescription()}</p>"))
                                    .element())
            .add(asyncHandlerTable)
            .add(asyncHandlerForm)
                            .element();
        expressionElements.put("html75", html75);
        navigation.addSecondary("logging-handler-item", "logging-handler-async-item", "Async Handler", loggingHandlerAsyncItemElement);
        HTMLElement html78;
        HTMLElement loggingHandlerConsoleItemElement = section()
            .add(html78 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Console Handler</h1><p>${metadata28.getDescription().getDescription()}</p>"))
                                    .element())
            .add(consoleHandlerTable)
            .add(consoleHandlerForm)
                            .element();
        expressionElements.put("html78", html78);
        navigation.addSecondary("logging-handler-item", "logging-handler-console-item", "Console Handler", loggingHandlerConsoleItemElement);
        HTMLElement html81;
        HTMLElement loggingHandlerCustomItemElement = section()
            .add(html81 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Handler</h1><p>${metadata29.getDescription().getDescription()}</p>"))
                                    .element())
            .add(customHandlerTable)
            .add(customHandlerForm)
                            .element();
        expressionElements.put("html81", html81);
        navigation.addSecondary("logging-handler-item", "logging-handler-custom-item", "Custom Handler", loggingHandlerCustomItemElement);
        HTMLElement html84;
        HTMLElement loggingHandlerFileItemElement = section()
            .add(html84 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>File Handler</h1><p>${metadata30.getDescription().getDescription()}</p>"))
                                    .element())
            .add(fileHandlerTable)
            .add(fileHandlerForm)
                            .element();
        expressionElements.put("html84", html84);
        navigation.addSecondary("logging-handler-item", "logging-handler-file-item", "File Handler", loggingHandlerFileItemElement);
        HTMLElement html87;
        HTMLElement loggingHandlerPeriodicRotatingFileItemElement = section()
            .add(html87 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Handler</h1><p>${metadata31.getDescription().getDescription()}</p>"))
                                    .element())
            .add(periodicHandlerTable)
            .add(periodicHandlerForm)
                            .element();
        expressionElements.put("html87", html87);
        navigation.addSecondary("logging-handler-item", "logging-handler-periodic-rotating-file-item", "Periodic Handler", loggingHandlerPeriodicRotatingFileItemElement);
        HTMLElement html90;
        HTMLElement loggingHandlerPeriodicSizeRotatingFileItemElement = section()
            .add(html90 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Size Handler</h1><p>${metadata32.getDescription().getDescription()}</p>"))
                                    .element())
            .add(periodicSizeHandlerTable)
            .add(periodicSizeHandlerForm)
                            .element();
        expressionElements.put("html90", html90);
        navigation.addSecondary("logging-handler-item", "logging-handler-periodic-size-rotating-file-item", "Periodic Size Handler", loggingHandlerPeriodicSizeRotatingFileItemElement);
        HTMLElement html93;
        HTMLElement loggingHandlerSizeRotatingFileItemElement = section()
            .add(html93 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Size Handler</h1><p>${metadata33.getDescription().getDescription()}</p>"))
                                    .element())
            .add(sizeHandlerTable)
            .add(sizeHandlerForm)
                            .element();
        expressionElements.put("html93", html93);
        navigation.addSecondary("logging-handler-item", "logging-handler-size-rotating-file-item", "Size Handler", loggingHandlerSizeRotatingFileItemElement);
        HTMLElement html96;
        HTMLElement loggingHandlerSocketItemElement = section()
            .add(html96 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Handler</h1><p>${metadata34.getDescription().getDescription()}</p>"))
                                    .element())
            .add(socketHandlerTable)
            .add(socketHandlerForm)
                            .element();
        expressionElements.put("html96", html96);
        navigation.addSecondary("logging-handler-item", "logging-handler-socket-item", "Socket Handler", loggingHandlerSocketItemElement);
        HTMLElement html99;
        HTMLElement loggingHandlerSyslogItemElement = section()
            .add(html99 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Syslog Handler</h1><p>${metadata35.getDescription().getDescription()}</p>"))
                                    .element())
            .add(syslogHandlerTable)
            .add(syslogHandlerForm)
                            .element();
        expressionElements.put("html99", html99);
        navigation.addSecondary("logging-handler-item", "logging-handler-syslog-item", "Syslog Handler", loggingHandlerSyslogItemElement);
        navigation.addPrimary("logging-formatter-item", "Formatter", "fa fa-paint-brush");
        HTMLElement html102;
        HTMLElement loggingFormatterCustomItemElement = section()
            .add(html102 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Formatter</h1><p>${metadata36.getDescription().getDescription()}</p>"))
                                    .element())
            .add(customFormatterTable)
            .add(customFormatterForm)
                            .element();
        expressionElements.put("html102", html102);
        navigation.addSecondary("logging-formatter-item", "logging-formatter-custom-item", "Custom Formatter", loggingFormatterCustomItemElement);
        HTMLElement html105;
        HTMLElement loggingFormatterPatternItemElement = section()
            .add(html105 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Pattern Formatter</h1><p>${metadata37.getDescription().getDescription()}</p>"))
                                    .element())
            .add(patternFormatterTable)
            .add(patternFormatterForm)
                            .element();
        expressionElements.put("html105", html105);
        navigation.addSecondary("logging-formatter-item", "logging-formatter-pattern-item", "Pattern Formatter", loggingFormatterPatternItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(loggingConfigForm);
        registerAttachable(rootLoggerForm);
        registerAttachable(loggerTable);
        registerAttachable(loggerForm);
        registerAttachable(consoleHandlerTable);
        registerAttachable(consoleHandlerForm);
        registerAttachable(fileHandlerTable);
        registerAttachable(fileHandlerForm);
        registerAttachable(periodicHandlerTable);
        registerAttachable(periodicHandlerForm);
        registerAttachable(periodicSizeHandlerTable);
        registerAttachable(periodicSizeHandlerForm);
        registerAttachable(sizeHandlerTable);
        registerAttachable(sizeHandlerForm);
        registerAttachable(asyncHandlerTable);
        registerAttachable(asyncHandlerForm);
        registerAttachable(customHandlerTable);
        registerAttachable(customHandlerForm);
        registerAttachable(socketHandlerTable);
        registerAttachable(socketHandlerForm);
        registerAttachable(syslogHandlerTable);
        registerAttachable(syslogHandlerForm);
        registerAttachable(customFormatterTable);
        registerAttachable(customFormatterForm);
        registerAttachable(patternFormatterTable);
        registerAttachable(patternFormatterForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            loggerTable.bindForm(loggerForm);
            consoleHandlerTable.bindForm(consoleHandlerForm);
            fileHandlerTable.bindForm(fileHandlerForm);
            periodicHandlerTable.bindForm(periodicHandlerForm);
            periodicSizeHandlerTable.bindForm(periodicSizeHandlerForm);
            sizeHandlerTable.bindForm(sizeHandlerForm);
            asyncHandlerTable.bindForm(asyncHandlerForm);
            customHandlerTable.bindForm(customHandlerForm);
            socketHandlerTable.bindForm(socketHandlerForm);
            syslogHandlerTable.bindForm(syslogHandlerForm);
            customFormatterTable.bindForm(customFormatterForm);
            patternFormatterTable.bindForm(patternFormatterForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html68"), "${metadata24.getDescription().getDescription()}", String.valueOf(metadata24.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html70"), "${metadata25.getDescription().getDescription()}", String.valueOf(metadata25.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html72"), "${metadata26.getDescription().getDescription()}", String.valueOf(metadata26.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html75"), "${metadata27.getDescription().getDescription()}", String.valueOf(metadata27.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html78"), "${metadata28.getDescription().getDescription()}", String.valueOf(metadata28.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html81"), "${metadata29.getDescription().getDescription()}", String.valueOf(metadata29.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html84"), "${metadata30.getDescription().getDescription()}", String.valueOf(metadata30.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html87"), "${metadata31.getDescription().getDescription()}", String.valueOf(metadata31.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html90"), "${metadata32.getDescription().getDescription()}", String.valueOf(metadata32.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html93"), "${metadata33.getDescription().getDescription()}", String.valueOf(metadata33.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html96"), "${metadata34.getDescription().getDescription()}", String.valueOf(metadata34.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html99"), "${metadata35.getDescription().getDescription()}", String.valueOf(metadata35.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html102"), "${metadata36.getDescription().getDescription()}", String.valueOf(metadata36.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html105"), "${metadata37.getDescription().getDescription()}", String.valueOf(metadata37.getDescription().getDescription()));
    }
}
