package org.jboss.hal.ballroom.form;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.HandlerRegistration;

import com.google.gwt.event.shared.HasHandlers;

public class EncryptExpressionEvent extends GwtEvent<EncryptExpressionEvent.EncryptExpressionHandler> { 

  org.jboss.hal.ballroom.form.AbstractFormItem formItem;

  protected EncryptExpressionEvent() {
    // Possibly for serialization.
  }

  public EncryptExpressionEvent(org.jboss.hal.ballroom.form.AbstractFormItem formItem) {
    this.formItem = formItem;
  }

  public static void fire(HasHandlers source, org.jboss.hal.ballroom.form.AbstractFormItem formItem) {
    EncryptExpressionEvent eventInstance = new EncryptExpressionEvent(formItem);
    source.fireEvent(eventInstance);
  }

  public static void fire(HasHandlers source, EncryptExpressionEvent eventInstance) {
    source.fireEvent(eventInstance);
  }

  public interface HasEncryptExpressionHandlers extends HasHandlers {
    HandlerRegistration addEncryptExpressionHandler(EncryptExpressionHandler handler);
  }

  public interface EncryptExpressionHandler extends EventHandler {
    public void onEncryptExpression(EncryptExpressionEvent event);
  }

  private static final Type<EncryptExpressionHandler> TYPE = new Type<EncryptExpressionHandler>();

  public static Type<EncryptExpressionHandler> getType() {
    return TYPE;
  }

  @Override
  public Type<EncryptExpressionHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(EncryptExpressionHandler handler) {
    handler.onEncryptExpression(this);
  }

  public org.jboss.hal.ballroom.form.AbstractFormItem getFormItem(){
    return formItem;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
        return true;
    if (obj == null)
        return false;
    if (getClass() != obj.getClass())
        return false;
    EncryptExpressionEvent other = (EncryptExpressionEvent) obj;
    if (formItem == null) {
      if (other.formItem != null)
        return false;
    } else if (!formItem.equals(other.formItem))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    int hashCode = 23;
    hashCode = (hashCode * 37) + (formItem == null ? 1 : formItem.hashCode());
    return hashCode;
  }

  @Override
  public String toString() {
    return "EncryptExpressionEvent["
                 + formItem
    + "]";
  }
}
