package org.jboss.hal.core.runtime.host;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.HandlerRegistration;

import com.google.gwt.event.shared.HasHandlers;

public class HostResultEvent extends GwtEvent<HostResultEvent.HostResultHandler> { 

  org.jboss.hal.core.runtime.host.Host host;
  java.util.List<org.jboss.hal.core.runtime.server.Server> servers;
  org.jboss.hal.flow.FlowStatus status;

  protected HostResultEvent() {
    // Possibly for serialization.
  }

  public HostResultEvent(org.jboss.hal.core.runtime.host.Host host, java.util.List<org.jboss.hal.core.runtime.server.Server> servers, org.jboss.hal.flow.FlowStatus status) {
    this.host = host;
    this.servers = servers;
    this.status = status;
  }

  public static void fire(HasHandlers source, org.jboss.hal.core.runtime.host.Host host, java.util.List<org.jboss.hal.core.runtime.server.Server> servers, org.jboss.hal.flow.FlowStatus status) {
    HostResultEvent eventInstance = new HostResultEvent(host, servers, status);
    source.fireEvent(eventInstance);
  }

  public static void fire(HasHandlers source, HostResultEvent eventInstance) {
    source.fireEvent(eventInstance);
  }

  public interface HasHostResultHandlers extends HasHandlers {
    HandlerRegistration addHostResultHandler(HostResultHandler handler);
  }

  public interface HostResultHandler extends EventHandler {
    public void onHostResult(HostResultEvent event);
  }

  private static final Type<HostResultHandler> TYPE = new Type<HostResultHandler>();

  public static Type<HostResultHandler> getType() {
    return TYPE;
  }

  @Override
  public Type<HostResultHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(HostResultHandler handler) {
    handler.onHostResult(this);
  }

  public org.jboss.hal.core.runtime.host.Host getHost(){
    return host;
  }

  public java.util.List<org.jboss.hal.core.runtime.server.Server> getServers(){
    return servers;
  }

  public org.jboss.hal.flow.FlowStatus getStatus(){
    return status;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
        return true;
    if (obj == null)
        return false;
    if (getClass() != obj.getClass())
        return false;
    HostResultEvent other = (HostResultEvent) obj;
    if (host == null) {
      if (other.host != null)
        return false;
    } else if (!host.equals(other.host))
      return false;
    if (servers == null) {
      if (other.servers != null)
        return false;
    } else if (!servers.equals(other.servers))
      return false;
    if (status == null) {
      if (other.status != null)
        return false;
    } else if (!status.equals(other.status))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    int hashCode = 23;
    hashCode = (hashCode * 37) + (host == null ? 1 : host.hashCode());
    hashCode = (hashCode * 37) + (servers == null ? 1 : servers.hashCode());
    hashCode = (hashCode * 37) + (status == null ? 1 : status.hashCode());
    return hashCode;
  }

  @Override
  public String toString() {
    return "HostResultEvent["
                 + host
                 + ","
                 + servers
                 + ","
                 + status
    + "]";
  }
}
