package org.jboss.hal.client.configuration.subsystem.undertow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_BufferCacheView extends BufferCacheView {

    private final Metadata metadata1;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_BufferCacheView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata1Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/buffer-cache=*");
        this.metadata1 = mbuiContext.metadataRegistry().lookup(metadata1Template);
        this.expressionElements = new HashMap<>();

        form = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("buffer-cache-form", metadata1)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Buffer Cache", name, metadata1Template.resolve(statementContext(), name), changedValues, metadata1);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Buffer Cache", name, metadata1Template.resolve(statementContext(), name), form, metadata1);
            })
            .build();

        table = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("buffer-cache-table", metadata1)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("buffer-cache-table", Ids.ADD), "Buffer Cache",
                metadata1Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Buffer Cache", metadata1Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        HTMLElement html2;
        HTMLElement root = row()
            .add(column()
                .add(html2 = div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Buffer Cache</h1><p>${metadata1.getDescription().getDescription()}</p>"))
                        .element())
                                .add(table)
                                .add(form)
                )
                .element();
        expressionElements.put("html2", html2);

        registerAttachable(table);
        registerAttachable(form);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            table.bindForm(form);

        ExpressionUtil.replaceExpression(expressionElements.get("html2"), "${metadata1.getDescription().getDescription()}", String.valueOf(metadata1.getDescription().getDescription()));
    }
}
