package org.jboss.hal.client.configuration.subsystem.microprofile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_MicroProfileConfigView extends MicroProfileConfigView {

    private final Metadata metadata107;
    private final Metadata metadata106;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_MicroProfileConfigView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata107Template = AddressTemplate.of("/{selected.profile}/subsystem=microprofile-config-smallrye/config-source-provider=*");
        this.metadata107 = mbuiContext.metadataRegistry().lookup(metadata107Template);
        AddressTemplate metadata106Template = AddressTemplate.of("/{selected.profile}/subsystem=microprofile-config-smallrye/config-source=*");
        this.metadata106 = mbuiContext.metadataRegistry().lookup(metadata106Template);
        this.expressionElements = new HashMap<>();

        configSourceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("microprofile-config-source-form", metadata106)
            .customFormItem("class", attributeDescription -> new ClassFormItem())
            .customFormItem("dir", attributeDescription -> new org.jboss.hal.core.ui.FileFormItem("dir", false))
            .include("properties")
            .include("ordinal")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Config Source", name, metadata106Template.resolve(statementContext(), name), changedValues, metadata106);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Config Source", name, metadata106Template.resolve(statementContext(), name), form, metadata106);
            })
            .build();
        configSourceProviderForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("microprofile-config-source-provider-form", metadata107)
            .customFormItem("class", attributeDescription -> new ClassFormItem())
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Config Source Provider", name, metadata107Template.resolve(statementContext(), name), changedValues, metadata107);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Config Source Provider", name, metadata107Template.resolve(statementContext(), name), form, metadata107);
            })
            .build();

        configSourceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("microprofile-config-source-table", metadata106)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(), Constraint.parse("executable({selected.profile}/subsystem=microprofile-config-smallrye/config-source=*:add)"))
            .button(mbuiContext.tableButtonFactory().remove("Config Source", metadata106Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("ordinal")
            .build();
        configSourceProviderTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("microprofile-config-source-provider-table", metadata107)
            .button(mbuiContext.tableButtonFactory().add(metadata107Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("microprofile-config-source-provider-table", Ids.ADD),
                    metadata107)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("class", attributeDescription -> new ClassFormItem())
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Config Provider"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata107Template.resolve(statementContext(), name);
                        mbuiContext.crud().add("Config Provider", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Config Provider", metadata107Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html315;
        HTMLElement microprofileConfigSourceItemElement = section()
            .add(html315 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Config Sources</h1><p>${metadata106.getDescription().getDescription()}</p>"))
                            .element())
            .add(configSourceTable)
            .add(configSourceForm)
                    .element();
        expressionElements.put("html315", html315);
        navigation.addPrimary("microprofile-config-source-item", "Config Sources", "fa fa-cogs", microprofileConfigSourceItemElement);
        HTMLElement html318;
        HTMLElement microprofileConfigSourceProviderItemElement = section()
            .add(html318 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Config Providers</h1><p>${metadata107.getDescription().getDescription()}</p>"))
                            .element())
            .add(configSourceProviderTable)
            .add(configSourceProviderForm)
                    .element();
        expressionElements.put("html318", html318);
        navigation.addPrimary("microprofile-config-source-provider-item", "Config Providers", "pficon pficon-services", microprofileConfigSourceProviderItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(configSourceTable);
        registerAttachable(configSourceForm);
        registerAttachable(configSourceProviderTable);
        registerAttachable(configSourceProviderForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            configSourceTable.bindForm(configSourceForm);
            configSourceProviderTable.bindForm(configSourceProviderForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html315"), "${metadata106.getDescription().getDescription()}", String.valueOf(metadata106.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html318"), "${metadata107.getDescription().getDescription()}", String.valueOf(metadata107.getDescription().getDescription()));
    }
}
