package org.jboss.hal.client.configuration.subsystem.distributableweb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.elemento.ElementsBag;
import org.jboss.elemento.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.elemento.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_DistributableWebView extends DistributableWebView {

    private final Metadata metadata113;
    private final Metadata metadata114;
    private final Metadata metadata115;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_DistributableWebView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata113Template = AddressTemplate.of("/{selected.profile}/subsystem=distributable-web");
        this.metadata113 = mbuiContext.metadataRegistry().lookup(metadata113Template);
        AddressTemplate metadata114Template = AddressTemplate.of("/{selected.profile}/subsystem=distributable-web/hotrod-single-sign-on-management=*");
        this.metadata114 = mbuiContext.metadataRegistry().lookup(metadata114Template);
        AddressTemplate metadata115Template = AddressTemplate.of("/{selected.profile}/subsystem=distributable-web/infinispan-single-sign-on-management=*");
        this.metadata115 = mbuiContext.metadataRegistry().lookup(metadata115Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("dw-configuration-form", metadata113)
            .onSave((form, changedValues) -> saveSingletonForm("Distributable Web", metadata113Template.resolve(statementContext()), changedValues, metadata113))
            .prepareReset(form -> resetSingletonForm("Distributable Web", metadata113Template.resolve(statementContext()), form, metadata113))
            .build();
        hotRodSSOManagementForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("dw-hotrod-sso-management-form", metadata114)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Hotrod Single Sign On Management", name, metadata114Template.resolve(statementContext(), name), changedValues, metadata114);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Hotrod Single Sign On Management", name, metadata114Template.resolve(statementContext(), name), form, metadata114);
            })
            .build();
        infinispanSSOManagementForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("dw-infinispan-sso-management-form", metadata115)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Infinispan Single Sign On Management", name, metadata115Template.resolve(statementContext(), name), changedValues, metadata115);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Infinispan Single Sign On Management", name, metadata115Template.resolve(statementContext(), name), form, metadata115);
            })
            .build();

        hotRodSSOManagementTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("dw-hotrod-sso-management-table", metadata114)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("dw-hotrod-sso-management-table", Ids.ADD), "Hotrod Single Sign On Management",
                metadata114Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Hotrod Single Sign On Management", metadata114Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        infinispanSSOManagementTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("dw-infinispan-sso-management-table", metadata115)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("dw-infinispan-sso-management-table", Ids.ADD), "Infinispan Single Sign On Management",
                metadata115Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Infinispan Single Sign On Management", metadata115Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html337;
        HTMLElement dwConfigurationItemElement = section()
            .add(html337 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Distributable Web</h1><p>${metadata113.getDescription().getDescription()}</p>"))
                            .element())
            .add(configurationForm)
                    .element();
        expressionElements.put("html337", html337);
        navigation.addPrimary("dw-configuration-item", "Configuration", "pficon pficon-settings", dwConfigurationItemElement);
        HTMLElement html339;
        HTMLElement dwHotrodSsoManagementItemElement = section()
            .add(html339 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HotRod SSO Management</h1><p>${metadata114.getDescription().getDescription()}</p>"))
                            .element())
            .add(hotRodSSOManagementTable)
            .add(hotRodSSOManagementForm)
                    .element();
        expressionElements.put("html339", html339);
        navigation.addPrimary("dw-hotrod-sso-management-item", "HotRod SSO", "fa fa-lock", dwHotrodSsoManagementItemElement);
        HTMLElement html342;
        HTMLElement dwInfinispanSsoManagementItemElement = section()
            .add(html342 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Infinispan SSO Management</h1><p>${metadata115.getDescription().getDescription()}</p>"))
                            .element())
            .add(infinispanSSOManagementTable)
            .add(infinispanSSOManagementForm)
                    .element();
        expressionElements.put("html342", html342);
        navigation.addPrimary("dw-infinispan-sso-management-item", "Infinispan SSO", "fa fa-lock", dwInfinispanSsoManagementItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(hotRodSSOManagementTable);
        registerAttachable(hotRodSSOManagementForm);
        registerAttachable(infinispanSSOManagementTable);
        registerAttachable(infinispanSSOManagementForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            hotRodSSOManagementTable.bindForm(hotRodSSOManagementForm);
            infinispanSSOManagementTable.bindForm(infinispanSSOManagementForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html337"), "${metadata113.getDescription().getDescription()}", String.valueOf(metadata113.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html339"), "${metadata114.getDescription().getDescription()}", String.valueOf(metadata114.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html342"), "${metadata115.getDescription().getDescription()}", String.valueOf(metadata115.getDescription().getDescription()));
    }
}
