package org.jboss.hal.client.runtime.host;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_HostView extends HostView {

    private final Metadata metadata55;
    private final Metadata metadata59;
    private final Metadata metadata57;
    private final Metadata metadata58;
    private final Metadata metadata56;
    private final Metadata metadata60;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_HostView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata55Template = AddressTemplate.of("/{selected.host}");
        this.metadata55 = mbuiContext.metadataRegistry().lookup(metadata55Template);
        AddressTemplate metadata59Template = AddressTemplate.of("/{selected.host}/socket-binding-group=*");
        this.metadata59 = mbuiContext.metadataRegistry().lookup(metadata59Template);
        AddressTemplate metadata57Template = AddressTemplate.of("/{selected.host}/jvm=*");
        this.metadata57 = mbuiContext.metadataRegistry().lookup(metadata57Template);
        AddressTemplate metadata58Template = AddressTemplate.of("/{selected.host}/path=*");
        this.metadata58 = mbuiContext.metadataRegistry().lookup(metadata58Template);
        AddressTemplate metadata56Template = AddressTemplate.of("/{selected.host}/interface=*");
        this.metadata56 = mbuiContext.metadataRegistry().lookup(metadata56Template);
        AddressTemplate metadata60Template = AddressTemplate.of("/{selected.host}/system-property=*");
        this.metadata60 = mbuiContext.metadataRegistry().lookup(metadata60Template);
        this.expressionElements = new HashMap<>();

        hostConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.host.Host>("host-configuration-form", metadata55)
            .includeRuntime()
            .include("name", "organization", "directory-grouping", "uuid", "release-codename", "release-version", "product-name", "product-version", "management-major-version", "management-minor-version", "management-micro-version", "running-mode", "host-state", "suspend-state")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveHost(form, changedValues))
            .prepareReset(form -> resetSingletonForm("Host Configuration", metadata55Template.resolve(statementContext()), form, metadata55))
            .build();
        hostInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-interface-form", metadata56)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Interface", name, metadata56Template.resolve(statementContext(), name), changedValues, metadata56);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Interface", name, metadata56Template.resolve(statementContext(), name), form, metadata56);
            })
            .build();
        hostJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-jvm-form", metadata57)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JVM", name, metadata57Template.resolve(statementContext(), name), changedValues, metadata57);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("JVM", name, metadata57Template.resolve(statementContext(), name), form, metadata57);
            })
            .build();
        hostPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-path-form", metadata58)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata58Template.resolve(statementContext(), name), changedValues, metadata58);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Path", name, metadata58Template.resolve(statementContext(), name), form, metadata58);
            })
            .build();
        hostSocketBindingGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-socket-binding-group-form", metadata59)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Socket Binding Group", name, metadata59Template.resolve(statementContext(), name), changedValues, metadata59);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Socket Binding Group", name, metadata59Template.resolve(statementContext(), name), form, metadata59);
            })
            .build();
        hostSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-system-property-form", metadata60)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata60Template.resolve(statementContext(), name), changedValues, metadata60);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata60Template.resolve(statementContext(), name), form, metadata60);
            })
            .build();

        hostInterfaceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-interface-table", metadata56)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-interface-table", Ids.ADD), "Interface",
                metadata56Template, asList("inet-address"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata56Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-jvm-table", metadata57)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-jvm-table", Ids.ADD), "JVM",
                metadata57Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JVM", metadata57Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        hostPathTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-path-table", metadata58)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-path-table", Ids.ADD), "Path",
                metadata58Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata58Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        hostSocketBindingGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-socket-binding-group-table", metadata59)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-socket-binding-group-table", Ids.ADD), "Socket Binding Group",
                metadata59Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Socket Binding Group", metadata59Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-system-property-table", metadata60)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-system-property-table", Ids.ADD), "System Property",
                metadata60Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata60Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html163;
        HTMLElement hostConfigurationItemElement = section()
            .add(html163 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"host-configuration-title\" /><p>${metadata55.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostConfigurationForm)
                    .element();
        expressionElements.put("html163", html163);
        navigation.addPrimary("host-configuration-item", "Configuration", "pficon pficon-settings", hostConfigurationItemElement);
        HTMLElement html165;
        HTMLElement hostInterfaceItemElement = section()
            .add(html165 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>${metadata56.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostInterfaceTable)
            .add(hostInterfaceForm)
                    .element();
        expressionElements.put("html165", html165);
        navigation.addPrimary("host-interface-item", "Interfaces", "fa fa-exchange", hostInterfaceItemElement);
        HTMLElement html168;
        HTMLElement hostJvmItemElement = section()
            .add(html168 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>${metadata57.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostJvmTable)
            .add(hostJvmForm)
                    .element();
        expressionElements.put("html168", html168);
        navigation.addPrimary("host-jvm-item", "JVMs", "fa fa-coffee", hostJvmItemElement);
        HTMLElement html171;
        HTMLElement hostPathItemElement = section()
            .add(html171 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>${metadata58.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostPathTable)
            .add(hostPathForm)
                    .element();
        expressionElements.put("html171", html171);
        navigation.addPrimary("host-path-item", "Paths", "fa fa-folder-open", hostPathItemElement);
        HTMLElement html174;
        HTMLElement hostSocketBindingGroupItemElement = section()
            .add(html174 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Binding Groups</h1><p>${metadata59.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostSocketBindingGroupTable)
            .add(hostSocketBindingGroupForm)
                    .element();
        expressionElements.put("html174", html174);
        navigation.addPrimary("host-socket-binding-group-item", "Socket Binding Groups", "fa fa-object-group", hostSocketBindingGroupItemElement);
        HTMLElement html177;
        HTMLElement hostSystemPropertyItemElement = section()
            .add(html177 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>${metadata60.getDescription().getDescription()}</p>"))
                            .element())
            .add(hostSystemPropertyTable)
            .add(hostSystemPropertyForm)
                    .element();
        expressionElements.put("html177", html177);
        navigation.addPrimary("host-system-property-item", "System Properties", "fa fa-list-ul", hostSystemPropertyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(hostConfigurationForm);
        registerAttachable(hostInterfaceTable);
        registerAttachable(hostInterfaceForm);
        registerAttachable(hostJvmTable);
        registerAttachable(hostJvmForm);
        registerAttachable(hostPathTable);
        registerAttachable(hostPathForm);
        registerAttachable(hostSocketBindingGroupTable);
        registerAttachable(hostSocketBindingGroupForm);
        registerAttachable(hostSystemPropertyTable);
        registerAttachable(hostSystemPropertyForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            hostInterfaceTable.bindForm(hostInterfaceForm);
            hostJvmTable.bindForm(hostJvmForm);
            hostPathTable.bindForm(hostPathForm);
            hostSocketBindingGroupTable.bindForm(hostSocketBindingGroupForm);
            hostSystemPropertyTable.bindForm(hostSystemPropertyForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html163"), "${metadata55.getDescription().getDescription()}", String.valueOf(metadata55.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html165"), "${metadata56.getDescription().getDescription()}", String.valueOf(metadata56.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html168"), "${metadata57.getDescription().getDescription()}", String.valueOf(metadata57.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html171"), "${metadata58.getDescription().getDescription()}", String.valueOf(metadata58.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html174"), "${metadata59.getDescription().getDescription()}", String.valueOf(metadata59.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html177"), "${metadata60.getDescription().getDescription()}", String.valueOf(metadata60.getDescription().getDescription()));
    }
}
