package org.jboss.hal.client.configuration.subsystem.coremanagement;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_CoreManagementView extends CoreManagementView {

    private final Metadata metadata111;
    private final Metadata metadata112;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_CoreManagementView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata111Template = AddressTemplate.of("/{selected.profile}/subsystem=core-management/service=configuration-changes");
        this.metadata111 = mbuiContext.metadataRegistry().lookup(metadata111Template);
        AddressTemplate metadata112Template = AddressTemplate.of("/{selected.profile}/subsystem=core-management/process-state-listener=*");
        this.metadata112 = mbuiContext.metadataRegistry().lookup(metadata112Template);
        this.expressionElements = new HashMap<>();

        confChangesForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("core-mgmt-conf-change-form", metadata111)
            .singleton(
                () -> new Operation.Builder(metadata111Template.resolve(statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> presenter.addConfigurationChanges())
            .prepareRemove(form -> removeSingletonForm("Configuration Changes", metadata111Template.resolve(statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Configuration Changes", metadata111Template.resolve(statementContext()), changedValues, metadata111))
            .prepareReset(form -> resetSingletonForm("Configuration Changes", metadata111Template.resolve(statementContext()), form, metadata111))
            .build();
        prcStateListenerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("core-mgmt-prc-state-form", metadata112)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Process State Listeners", name, metadata112Template.resolve(statementContext(), name), changedValues, metadata112);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Process State Listeners", name, metadata112Template.resolve(statementContext(), name), form, metadata112);
            })
            .build();

        prcStateListenerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("core-mgmt-prc-state-table", metadata112)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("core-mgmt-prc-state-table", Ids.ADD), "Process State Listeners",
                metadata112Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Process State Listeners", metadata112Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html332;
        HTMLElement coreMgmtConfChangeItemElement = section()
            .add(html332 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration Changes</h1><p>${metadata111.getDescription().getDescription()}</p>"))
                            .element())
            .add(confChangesForm)
                    .element();
        expressionElements.put("html332", html332);
        navigation.addPrimary("core-mgmt-conf-change-item", "Configuration Changes", "pficon pficon-settings", coreMgmtConfChangeItemElement);
        HTMLElement html334;
        HTMLElement coreMgmtPrcStateItemElement = section()
            .add(html334 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Process State Listeners</h1><p>${metadata112.getDescription().getDescription()}</p>"))
                            .element())
            .add(prcStateListenerTable)
            .add(prcStateListenerForm)
                    .element();
        expressionElements.put("html334", html334);
        navigation.addPrimary("core-mgmt-prc-state-item", "Process State Listeners", "pficon pficon-memory", coreMgmtPrcStateItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(confChangesForm);
        registerAttachable(prcStateListenerTable);
        registerAttachable(prcStateListenerForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();


        ExpressionUtil.replaceExpression(expressionElements.get("html332"), "${metadata111.getDescription().getDescription()}", String.valueOf(metadata111.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html334"), "${metadata112.getDescription().getDescription()}", String.valueOf(metadata112.getDescription().getDescription()));
    }
}
