package org.jboss.hal.client.runtime.group;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ServerGroupView extends ServerGroupView {

    private final Metadata metadata48;
    private final Metadata metadata47;
    private final Metadata metadata49;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ServerGroupView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata48Template = AddressTemplate.of("/{selected.group}/jvm=*");
        this.metadata48 = mbuiContext.metadataRegistry().lookup(metadata48Template);
        AddressTemplate metadata47Template = AddressTemplate.of("/{selected.group}");
        this.metadata47 = mbuiContext.metadataRegistry().lookup(metadata47Template);
        AddressTemplate metadata49Template = AddressTemplate.of("/{selected.group}/system-property=*");
        this.metadata49 = mbuiContext.metadataRegistry().lookup(metadata49Template);
        this.expressionElements = new HashMap<>();

        serverGroupConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.group.ServerGroup>("server-group-configuration-form", metadata47)
            .includeRuntime()
            .include("profile", "socket-binding-group", "socket-binding-port-offset", "socket-binding-default-interface", "management-subsystem-endpoint")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Server Group Configuration", metadata47Template.resolve(statementContext()), changedValues, metadata47))
            .prepareReset(form -> resetSingletonForm("Server Group Configuration", metadata47Template.resolve(statementContext()), form, metadata47))
            .build();
        serverGroupJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-group-jvm-form", metadata48)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JVM", name, metadata48Template.resolve(statementContext(), name), changedValues, metadata48);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("JVM", name, metadata48Template.resolve(statementContext(), name), form, metadata48);
            })
            .build();
        serverGroupSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-group-system-property-form", metadata49)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata49Template.resolve(statementContext(), name), changedValues, metadata49);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata49Template.resolve(statementContext(), name), form, metadata49);
            })
            .build();

        serverGroupJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-group-jvm-table", metadata48)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-group-jvm-table", Ids.ADD), "JVM",
                metadata48Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JVM", metadata48Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverGroupSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-group-system-property-table", metadata49)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-group-system-property-table", Ids.ADD), "System Property",
                metadata49Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata49Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html140;
        HTMLElement serverGroupConfigurationItemElement = section()
            .add(html140 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Group Configuration</h1><p>${metadata47.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverGroupConfigurationForm)
                    .element();
        expressionElements.put("html140", html140);
        navigation.addPrimary("server-group-configuration-item", "Configuration", "pficon pficon-settings", serverGroupConfigurationItemElement);
        HTMLElement html142;
        HTMLElement serverGroupJvmItemElement = section()
            .add(html142 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>${metadata48.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverGroupJvmTable)
            .add(serverGroupJvmForm)
                    .element();
        expressionElements.put("html142", html142);
        navigation.addPrimary("server-group-jvm-item", "JVMs", "fa fa-coffee", serverGroupJvmItemElement);
        HTMLElement html145;
        HTMLElement serverGroupSystemPropertyItemElement = section()
            .add(html145 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>${metadata49.getDescription().getDescription()}</p>"))
                            .element())
            .add(serverGroupSystemPropertyTable)
            .add(serverGroupSystemPropertyForm)
                    .element();
        expressionElements.put("html145", html145);
        navigation.addPrimary("server-group-system-property-item", "System Properties", "fa fa-list-ul", serverGroupSystemPropertyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(serverGroupConfigurationForm);
        registerAttachable(serverGroupJvmTable);
        registerAttachable(serverGroupJvmForm);
        registerAttachable(serverGroupSystemPropertyTable);
        registerAttachable(serverGroupSystemPropertyForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            serverGroupJvmTable.bindForm(serverGroupJvmForm);
            serverGroupSystemPropertyTable.bindForm(serverGroupSystemPropertyForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html140"), "${metadata47.getDescription().getDescription()}", String.valueOf(metadata47.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html142"), "${metadata48.getDescription().getDescription()}", String.valueOf(metadata48.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html145"), "${metadata49.getDescription().getDescription()}", String.valueOf(metadata49.getDescription().getDescription()));
    }
}
