package org.jboss.hal.client.configuration.subsystem.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_SecurityView extends SecurityView {

    private final Metadata metadata49;
    private final Metadata metadata52;
    private final Metadata metadata50;
    private final Metadata metadata48;
    private final Metadata metadata53;
    private final Metadata metadata51;
    private final Metadata metadata47;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_SecurityView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata49Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-store=*");
        this.metadata49 = mbuiContext.metadataRegistry().lookup(metadata49Template);
        AddressTemplate metadata52Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-store=*");
        this.metadata52 = mbuiContext.metadataRegistry().lookup(metadata52Template);
        AddressTemplate metadata50Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-realm=*");
        this.metadata50 = mbuiContext.metadataRegistry().lookup(metadata50Template);
        AddressTemplate metadata48Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-manager=*");
        this.metadata48 = mbuiContext.metadataRegistry().lookup(metadata48Template);
        AddressTemplate metadata53Template = AddressTemplate.of("/{selected.profile}/subsystem=security/vault=classic");
        this.metadata53 = mbuiContext.metadataRegistry().lookup(metadata53Template);
        AddressTemplate metadata51Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-manager=*");
        this.metadata51 = mbuiContext.metadataRegistry().lookup(metadata51Template);
        AddressTemplate metadata47Template = AddressTemplate.of("/{selected.profile}/subsystem=security");
        this.metadata47 = mbuiContext.metadataRegistry().lookup(metadata47Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-configuration-form", metadata47)
            .onSave((form, changedValues) -> saveSingletonForm("Configuration", metadata47Template.resolve(statementContext()), changedValues, metadata47))
            .prepareReset(form -> resetSingletonForm("Configuration", metadata47Template.resolve(statementContext()), form, metadata47))
            .build();
        keyManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-manager-form", metadata48)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Manager", name, metadata48Template.resolve(statementContext(), name), changedValues, metadata48);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Key Manager", name, metadata48Template.resolve(statementContext(), name), form, metadata48);
            })
            .build();
        keyStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-store-form", metadata49)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Store", name, metadata49Template.resolve(statementContext(), name), changedValues, metadata49);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Key Store", name, metadata49Template.resolve(statementContext(), name), form, metadata49);
            })
            .build();
        realmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-realm-form", metadata50)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Realm", name, metadata50Template.resolve(statementContext(), name), changedValues, metadata50);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Realm", name, metadata50Template.resolve(statementContext(), name), form, metadata50);
            })
            .build();
        trustManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-manager-form", metadata51)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Manager", name, metadata51Template.resolve(statementContext(), name), changedValues, metadata51);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Trust Manager", name, metadata51Template.resolve(statementContext(), name), form, metadata51);
            })
            .build();
        trustStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-store-form", metadata52)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Store", name, metadata52Template.resolve(statementContext(), name), changedValues, metadata52);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Trust Store", name, metadata52Template.resolve(statementContext(), name), form, metadata52);
            })
            .build();
        vaultForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-vault-form", metadata53)
            .singleton(
                () -> new Operation.Builder(metadata53Template.resolve(statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("security-vault-form", "Vault", metadata53Template))
            .prepareRemove(form -> removeSingletonForm("Vault", metadata53Template.resolve(statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Vault", metadata53Template.resolve(statementContext()), changedValues, metadata53))
            .prepareReset(form -> resetSingletonForm("Vault", metadata53Template.resolve(statementContext()), form, metadata53))
            .build();

        keyManagerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-manager-table", metadata48)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-manager-table", Ids.ADD), "Elytron Key Manager",
                metadata48Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Manager", metadata48Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        keyStoreTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-store-table", metadata49)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-store-table", Ids.ADD), "Elytron Key Store",
                metadata49Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Store", metadata49Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        realmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-realm-table", metadata50)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-realm-table", Ids.ADD), "Elytron Realm",
                metadata50Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Realm", metadata50Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jaas-config")
            .build();
        trustManagerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-manager-table", metadata51)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-manager-table", Ids.ADD), "Elytron Trust Manager",
                metadata51Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Manager", metadata51Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        trustStoreTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-store-table", metadata52)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-store-table", Ids.ADD), "Elytron Trust Store",
                metadata52Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Store", metadata52Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html136;
        HTMLElement securityConfigurationItemElement = section()
            .add(html136 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata47.getDescription().getDescription()}</p>"))
                            .element())
            .add(configurationForm)
                    .element();
        expressionElements.put("html136", html136);
        navigation.addPrimary("security-configuration-item", "Configuration", "pficon pficon-settings", securityConfigurationItemElement);
        HTMLElement html138;
        HTMLElement securityElytronKeyManagerItemElement = section()
            .add(html138 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Manager</h1><p>${metadata48.getDescription().getDescription()}</p>"))
                            .element())
            .add(keyManagerTable)
            .add(keyManagerForm)
                    .element();
        expressionElements.put("html138", html138);
        navigation.addPrimary("security-elytron-key-manager-item", "Key Manager", "fa fa-key", securityElytronKeyManagerItemElement);
        HTMLElement html141;
        HTMLElement securityElytronKeyStoreItemElement = section()
            .add(html141 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Store</h1><p>${metadata49.getDescription().getDescription()}</p>"))
                            .element())
            .add(keyStoreTable)
            .add(keyStoreForm)
                    .element();
        expressionElements.put("html141", html141);
        navigation.addPrimary("security-elytron-key-store-item", "Key Store", "fa fa-key", securityElytronKeyStoreItemElement);
        HTMLElement html144;
        HTMLElement securityElytronRealmItemElement = section()
            .add(html144 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Realm</h1><p>${metadata50.getDescription().getDescription()}</p>"))
                            .element())
            .add(realmTable)
            .add(realmForm)
                    .element();
        expressionElements.put("html144", html144);
        navigation.addPrimary("security-elytron-realm-item", "Realm", "fa fa-map", securityElytronRealmItemElement);
        HTMLElement html147;
        HTMLElement securityElytronTrustManagerItemElement = section()
            .add(html147 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Manager</h1><p>${metadata51.getDescription().getDescription()}</p>"))
                            .element())
            .add(trustManagerTable)
            .add(trustManagerForm)
                    .element();
        expressionElements.put("html147", html147);
        navigation.addPrimary("security-elytron-trust-manager-item", "Trust Manager", "fa fa-lock", securityElytronTrustManagerItemElement);
        HTMLElement html150;
        HTMLElement securityElytronTrustStoreItemElement = section()
            .add(html150 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Store</h1><p>${metadata52.getDescription().getDescription()}</p>"))
                            .element())
            .add(trustStoreTable)
            .add(trustStoreForm)
                    .element();
        expressionElements.put("html150", html150);
        navigation.addPrimary("security-elytron-trust-store-item", "Trust Store", "fa fa-lock", securityElytronTrustStoreItemElement);
        HTMLElement html153;
        HTMLElement securityVaultItemElement = section()
            .add(html153 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Vault</h1><p>${metadata53.getDescription().getDescription()}</p>"))
                            .element())
            .add(vaultForm)
                    .element();
        expressionElements.put("html153", html153);
        navigation.addPrimary("security-vault-item", "Vault", "fa fa-shield", securityVaultItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(keyManagerTable);
        registerAttachable(keyManagerForm);
        registerAttachable(keyStoreTable);
        registerAttachable(keyStoreForm);
        registerAttachable(realmTable);
        registerAttachable(realmForm);
        registerAttachable(trustManagerTable);
        registerAttachable(trustManagerForm);
        registerAttachable(trustStoreTable);
        registerAttachable(trustStoreForm);
        registerAttachable(vaultForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            keyManagerTable.bindForm(keyManagerForm);
            keyStoreTable.bindForm(keyStoreForm);
            realmTable.bindForm(realmForm);
            trustManagerTable.bindForm(trustManagerForm);
            trustStoreTable.bindForm(trustStoreForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html136"), "${metadata47.getDescription().getDescription()}", String.valueOf(metadata47.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html138"), "${metadata48.getDescription().getDescription()}", String.valueOf(metadata48.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html141"), "${metadata49.getDescription().getDescription()}", String.valueOf(metadata49.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html144"), "${metadata50.getDescription().getDescription()}", String.valueOf(metadata50.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html147"), "${metadata51.getDescription().getDescription()}", String.valueOf(metadata51.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html150"), "${metadata52.getDescription().getDescription()}", String.valueOf(metadata52.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html153"), "${metadata53.getDescription().getDescription()}", String.valueOf(metadata53.getDescription().getDescription()));
    }
}
