package org.jboss.hal.client.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_SocketBindingGroupView extends SocketBindingGroupView {

    private final Metadata metadata144;
    private final Metadata metadata143;
    private final Metadata metadata142;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_SocketBindingGroupView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata144Template = AddressTemplate.of("/socket-binding-group=*/remote-destination-outbound-socket-binding=*");
        this.metadata144 = mbuiContext.metadataRegistry().lookup(metadata144Template);
        AddressTemplate metadata143Template = AddressTemplate.of("/socket-binding-group=*/local-destination-outbound-socket-binding=*");
        this.metadata143 = mbuiContext.metadataRegistry().lookup(metadata143Template);
        AddressTemplate metadata142Template = AddressTemplate.of("/socket-binding-group=*");
        this.metadata142 = mbuiContext.metadataRegistry().lookup(metadata142Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("socket-binding-group-configuration-form", metadata142)
            .include("default-interface", "includes")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveSocketBindingGroup(changedValues))
            .prepareReset(form -> presenter.resetSocketBindingGroup(form))
            .build();
        outboundLocalForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("socket-binding-group-outbound-local-form", metadata143)
            .include("socket-binding-ref", "source-interface", "source-port", "fixed-source-port")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveSocketBinding(SocketBinding.OUTBOUND_LOCAL, form, changedValues))
            .prepareReset(form -> presenter.resetSocketBinding(SocketBinding.OUTBOUND_LOCAL, form))
            .build();
        outboundLocalForm.getFormItem("socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        outboundRemoteForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("socket-binding-group-outbound-remote-form", metadata144)
            .include("host", "port", "source-interface", "source-port", "fixed-source-port")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveSocketBinding(SocketBinding.OUTBOUND_REMOTE, form, changedValues))
            .prepareReset(form -> presenter.resetSocketBinding(SocketBinding.OUTBOUND_REMOTE, form))
            .build();

        outboundLocalTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("socket-binding-group-outbound-local-table", metadata143)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addSocketBinding(SocketBinding.OUTBOUND_LOCAL), Constraint.parse("executable(socket-binding-group=*/local-destination-outbound-socket-binding=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeSocketBinding(SocketBinding.OUTBOUND_LOCAL, table.selectedRow().getName()), Scope.SELECTED, Constraint.parse("executable(socket-binding-group=*/local-destination-outbound-socket-binding=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        outboundRemoteTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("socket-binding-group-outbound-remote-table", metadata144)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addSocketBinding(SocketBinding.OUTBOUND_REMOTE), Constraint.parse("executable(socket-binding-group=*/remote-destination-outbound-socket-binding=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeSocketBinding(SocketBinding.OUTBOUND_REMOTE, table.selectedRow().getName()), Scope.SELECTED, Constraint.parse("executable(socket-binding-group=*/remote-destination-outbound-socket-binding=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("host", (cell, type, row, meta) -> row.get("host").asString())
            .column("port", (cell, type, row, meta) -> row.get("port").asString())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html427;
        HTMLElement socketBindingGroupConfigurationItemElement = section()
            .add(html427 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Binding Group</h1><p>${metadata142.getDescription().getDescription()}</p>"))
                            .get())
            .add(configurationForm)
                    .get();
        expressionElements.put("html427", html427);
        navigation.addPrimary("socket-binding-group-configuration-item", "Configuration", "pficon pficon-settings", socketBindingGroupConfigurationItemElement);
        HTMLElement html429;
        HTMLElement socketBindingGroupOutboundLocalItemElement = section()
            .add(html429 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Outbound Local</h1><p>${metadata143.getDescription().getDescription()}</p>"))
                            .get())
            .add(outboundLocalTable)
            .add(outboundLocalForm)
                    .get();
        expressionElements.put("html429", html429);
        navigation.addPrimary("socket-binding-group-outbound-local-item", "Outbound Local", "fa fa-arrow-circle-o-right", socketBindingGroupOutboundLocalItemElement);
        HTMLElement html432;
        HTMLElement socketBindingGroupOutboundRemoteItemElement = section()
            .add(html432 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Outbound Remote</h1><p>${metadata144.getDescription().getDescription()}</p>"))
                            .get())
            .add(outboundRemoteTable)
            .add(outboundRemoteForm)
                    .get();
        expressionElements.put("html432", html432);
        navigation.addPrimary("socket-binding-group-outbound-remote-item", "Outbound Remote", "fa fa-arrow-circle-right", socketBindingGroupOutboundRemoteItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .get();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(outboundLocalTable);
        registerAttachable(outboundLocalForm);
        registerAttachable(outboundRemoteTable);
        registerAttachable(outboundRemoteForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            outboundLocalTable.bindForm(outboundLocalForm);
            outboundRemoteTable.bindForm(outboundRemoteForm);

        TemplateUtil.replaceExpression(expressionElements.get("html427"), "${metadata142.getDescription().getDescription()}", String.valueOf(metadata142.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html429"), "${metadata143.getDescription().getDescription()}", String.valueOf(metadata143.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html432"), "${metadata144.getDescription().getDescription()}", String.valueOf(metadata144.getDescription().getDescription()));
    }
}
