package org.jboss.hal.core.runtime.group;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.HandlerRegistration;

import com.google.gwt.event.shared.HasHandlers;

public class ServerGroupResultEvent extends GwtEvent<ServerGroupResultEvent.ServerGroupResultHandler> { 

  org.jboss.hal.core.runtime.group.ServerGroup serverGroup;
  java.util.List<org.jboss.hal.core.runtime.server.Server> servers;
  org.jboss.hal.core.runtime.Result result;

  protected ServerGroupResultEvent() {
    // Possibly for serialization.
  }

  public ServerGroupResultEvent(org.jboss.hal.core.runtime.group.ServerGroup serverGroup, java.util.List<org.jboss.hal.core.runtime.server.Server> servers, org.jboss.hal.core.runtime.Result result) {
    this.serverGroup = serverGroup;
    this.servers = servers;
    this.result = result;
  }

  public static void fire(HasHandlers source, org.jboss.hal.core.runtime.group.ServerGroup serverGroup, java.util.List<org.jboss.hal.core.runtime.server.Server> servers, org.jboss.hal.core.runtime.Result result) {
    ServerGroupResultEvent eventInstance = new ServerGroupResultEvent(serverGroup, servers, result);
    source.fireEvent(eventInstance);
  }

  public static void fire(HasHandlers source, ServerGroupResultEvent eventInstance) {
    source.fireEvent(eventInstance);
  }

  public interface HasServerGroupResultHandlers extends HasHandlers {
    HandlerRegistration addServerGroupResultHandler(ServerGroupResultHandler handler);
  }

  public interface ServerGroupResultHandler extends EventHandler {
    public void onServerGroupResult(ServerGroupResultEvent event);
  }

  private static final Type<ServerGroupResultHandler> TYPE = new Type<ServerGroupResultHandler>();

  public static Type<ServerGroupResultHandler> getType() {
    return TYPE;
  }

  @Override
  public Type<ServerGroupResultHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(ServerGroupResultHandler handler) {
    handler.onServerGroupResult(this);
  }

  public org.jboss.hal.core.runtime.group.ServerGroup getServerGroup(){
    return serverGroup;
  }

  public java.util.List<org.jboss.hal.core.runtime.server.Server> getServers(){
    return servers;
  }

  public org.jboss.hal.core.runtime.Result getResult(){
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
        return true;
    if (obj == null)
        return false;
    if (getClass() != obj.getClass())
        return false;
    ServerGroupResultEvent other = (ServerGroupResultEvent) obj;
    if (serverGroup == null) {
      if (other.serverGroup != null)
        return false;
    } else if (!serverGroup.equals(other.serverGroup))
      return false;
    if (servers == null) {
      if (other.servers != null)
        return false;
    } else if (!servers.equals(other.servers))
      return false;
    if (result == null) {
      if (other.result != null)
        return false;
    } else if (!result.equals(other.result))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    int hashCode = 23;
    hashCode = (hashCode * 37) + (serverGroup == null ? 1 : serverGroup.hashCode());
    hashCode = (hashCode * 37) + (servers == null ? 1 : servers.hashCode());
    hashCode = (hashCode * 37) + (result == null ? 1 : result.hashCode());
    return hashCode;
  }

  @Override
  public String toString() {
    return "ServerGroupResultEvent["
                 + serverGroup
                 + ","
                 + servers
                 + ","
                 + result
    + "]";
  }
}
