package org.jboss.hal.core.runtime.host;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.HandlerRegistration;

import com.google.gwt.event.shared.HasHandlers;

public class HostActionEvent extends GwtEvent<HostActionEvent.HostActionHandler> { 

  org.jboss.hal.core.runtime.host.Host host;
  java.util.List<org.jboss.hal.core.runtime.server.Server> servers;
  org.jboss.hal.core.runtime.Action action;

  protected HostActionEvent() {
    // Possibly for serialization.
  }

  public HostActionEvent(org.jboss.hal.core.runtime.host.Host host, java.util.List<org.jboss.hal.core.runtime.server.Server> servers, org.jboss.hal.core.runtime.Action action) {
    this.host = host;
    this.servers = servers;
    this.action = action;
  }

  public static void fire(HasHandlers source, org.jboss.hal.core.runtime.host.Host host, java.util.List<org.jboss.hal.core.runtime.server.Server> servers, org.jboss.hal.core.runtime.Action action) {
    HostActionEvent eventInstance = new HostActionEvent(host, servers, action);
    source.fireEvent(eventInstance);
  }

  public static void fire(HasHandlers source, HostActionEvent eventInstance) {
    source.fireEvent(eventInstance);
  }

  public interface HasHostActionHandlers extends HasHandlers {
    HandlerRegistration addHostActionHandler(HostActionHandler handler);
  }

  public interface HostActionHandler extends EventHandler {
    public void onHostAction(HostActionEvent event);
  }

  private static final Type<HostActionHandler> TYPE = new Type<HostActionHandler>();

  public static Type<HostActionHandler> getType() {
    return TYPE;
  }

  @Override
  public Type<HostActionHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(HostActionHandler handler) {
    handler.onHostAction(this);
  }

  public org.jboss.hal.core.runtime.host.Host getHost(){
    return host;
  }

  public java.util.List<org.jboss.hal.core.runtime.server.Server> getServers(){
    return servers;
  }

  public org.jboss.hal.core.runtime.Action getAction(){
    return action;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
        return true;
    if (obj == null)
        return false;
    if (getClass() != obj.getClass())
        return false;
    HostActionEvent other = (HostActionEvent) obj;
    if (host == null) {
      if (other.host != null)
        return false;
    } else if (!host.equals(other.host))
      return false;
    if (servers == null) {
      if (other.servers != null)
        return false;
    } else if (!servers.equals(other.servers))
      return false;
    if (action == null) {
      if (other.action != null)
        return false;
    } else if (!action.equals(other.action))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    int hashCode = 23;
    hashCode = (hashCode * 37) + (host == null ? 1 : host.hashCode());
    hashCode = (hashCode * 37) + (servers == null ? 1 : servers.hashCode());
    hashCode = (hashCode * 37) + (action == null ? 1 : action.hashCode());
    return hashCode;
  }

  @Override
  public String toString() {
    return "HostActionEvent["
                 + host
                 + ","
                 + servers
                 + ","
                 + action
    + "]";
  }
}
