package org.jboss.hal.client.configuration.subsystem.remoting;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_RemotingView extends RemotingView {

    private final Metadata metadata14;
    private final Metadata metadata12;
    private final Metadata metadata11;
    private final Metadata metadata13;
    private final Metadata metadata10;
    private final Metadata metadata15;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_RemotingView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata14Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/outbound-connection=*");
        this.metadata14 = mbuiContext.metadataRegistry().lookup(metadata14Template);
        AddressTemplate metadata12Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/http-connector=*");
        this.metadata12 = mbuiContext.metadataRegistry().lookup(metadata12Template);
        AddressTemplate metadata11Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/connector=*");
        this.metadata11 = mbuiContext.metadataRegistry().lookup(metadata11Template);
        AddressTemplate metadata13Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/local-outbound-connection=*");
        this.metadata13 = mbuiContext.metadataRegistry().lookup(metadata13Template);
        AddressTemplate metadata10Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting");
        this.metadata10 = mbuiContext.metadataRegistry().lookup(metadata10Template);
        AddressTemplate metadata15Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/remote-outbound-connection=*");
        this.metadata15 = mbuiContext.metadataRegistry().lookup(metadata15Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new GroupedForm.Builder<org.jboss.hal.dmr.ModelNode>("remoting-configuration", metadata10)
            .customGroup("remoting-configuration-attributes", mbuiContext.resources().constants().attributes())
                .include("buffer-region-size", "heartbeat-interval", "receive-buffer-size", "receive-window-size", "send-buffer-size", "server-name", "transmit-window-size", "worker")
            .end()
            .customGroup("remoting-configuration-security", mbuiContext.resources().constants().security())
                .include("auth-realm", "authentication-retries", "authorize-id", "sasl-protocol")
            .end()
            .customGroup("remoting-configuration-channels", "Channels")
                .include("max-inbound-channels", "max-inbound-message-size", "max-inbound-messages", "max-outbound-channels", "max-outbound-message-size", "max-outbound-messages")
            .end()
            .onSave((form, changedValues) -> saveSingletonForm("Configuration", metadata10Template.resolve(mbuiContext.statementContext()), changedValues, metadata10))
            .prepareReset(form -> resetSingletonForm("Configuration", metadata10Template.resolve(mbuiContext.statementContext()), form, metadata10))
            .build();
        localOutboundForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("remoting-local-outbound-form", metadata13)
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("property"), 0)
            .include("outbound-socket-binding-ref")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveLocalOutbound(form, changedValues))
            .prepareReset(form -> presenter.resetLocalOutbound(form))
            .build();
        localOutboundForm.getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/local-destination-outbound-socket-binding=*")));
        outboundForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("remoting-outbound-form", metadata14)
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("property"), 0)
            .include("uri")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveOutbound(form, changedValues))
            .prepareReset(form -> presenter.resetOutbound(form))
            .build();
        remoteOutboundForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("remoting-remote-outbound-form", metadata15)
            .include("outbound-socket-binding-ref")
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("property"), 1)
            .include("protocol")
            .include("security-realm")
            .include("username")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveRemoteOutbound(form, changedValues))
            .prepareReset(form -> presenter.resetRemoteOutbound(form))
            .build();
        remoteOutboundForm.getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/remote-destination-outbound-socket-binding=*")));

        connectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-connector-table", metadata11)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-connector-table", Ids.ADD), "Connector",
                metadata11Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Connector", metadata11Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        httpConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-http-connector-table", metadata12)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-http-connector-table", Ids.ADD), "HTTP Connector",
                metadata12Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("HTTP Connector", metadata12Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        localOutboundTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-local-outbound-table", metadata13)
            .button(mbuiContext.tableButtonFactory().add(metadata13Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("remoting-local-outbound-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Local Outbound"),
                    metadata13,
                    asList("outbound-socket-binding-ref"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata13Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Local Outbound", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/local-destination-outbound-socket-binding=*")));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Local Outbound", metadata13Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        outboundTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-outbound-table", metadata14)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-outbound-table", Ids.ADD), "Outbound",
                metadata14Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Outbound", metadata14Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        remoteOutboundTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("remoting-remote-outbound-table", metadata15)
            .button(mbuiContext.tableButtonFactory().add(metadata15Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("remoting-remote-outbound-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Remote Outbound"),
                    metadata15,
                    asList("outbound-socket-binding-ref"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata15Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Remote Outbound", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/remote-destination-outbound-socket-binding=*")));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Remote Outbound", metadata15Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html29;
        HTMLElement remotingConfigurationItemElement = section()
            .add(html29 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata10.getDescription().getDescription()}</p>"))
                .asElement())
            .add(configurationForm)
            .asElement();
        expressionElements.put("html29", html29);
        navigation.addPrimary("remoting-configuration-item", "Configuration", "pficon pficon-settings", remotingConfigurationItemElement);
        navigation.addPrimary("remoting-remote-connector-item", "Remote Connector", "pficon pficon-network");
        HTMLElement html31;
        HTMLElement remotingConnectorSubItemElement = section()
            .add(html31 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connector</h1><p>${metadata11.getDescription().getDescription()}</p>"))
                .asElement())
            .add(connectorTable)
            .asElement();
        expressionElements.put("html31", html31);
        navigation.addSecondary("remoting-remote-connector-item", "remoting-connector-sub-item", "Connector", remotingConnectorSubItemElement);
        HTMLElement html33;
        HTMLElement remotingHttpConnectorSubItemElement = section()
            .add(html33 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Connector</h1><p>${metadata12.getDescription().getDescription()}</p>"))
                .asElement())
            .add(httpConnectorTable)
            .asElement();
        expressionElements.put("html33", html33);
        navigation.addSecondary("remoting-remote-connector-item", "remoting-http-connector-sub-item", "HTTP Connector", remotingHttpConnectorSubItemElement);
        navigation.addPrimary("remoting-outbound-connection-item", "Outbound Connection", "pficon pficon-service");
        HTMLElement html35;
        HTMLElement remotingLocalOutboundSubItemElement = section()
            .add(html35 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Local Outbound</h1><p>${metadata13.getDescription().getDescription()}</p>"))
                .asElement())
            .add(localOutboundTable)
            .add(localOutboundForm)
            .asElement();
        expressionElements.put("html35", html35);
        navigation.addSecondary("remoting-outbound-connection-item", "remoting-local-outbound-sub-item", "Local Outbound", remotingLocalOutboundSubItemElement);
        HTMLElement html38;
        HTMLElement remotingOutboundSubItemElement = section()
            .add(html38 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Outbound</h1><p>${metadata14.getDescription().getDescription()}</p>"))
                .asElement())
            .add(outboundTable)
            .add(outboundForm)
            .asElement();
        expressionElements.put("html38", html38);
        navigation.addSecondary("remoting-outbound-connection-item", "remoting-outbound-sub-item", "Outbound", remotingOutboundSubItemElement);
        HTMLElement html41;
        HTMLElement remotingRemoteOutboundSubItemElement = section()
            .add(html41 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Outbound</h1><p>${metadata15.getDescription().getDescription()}</p>"))
                .asElement())
            .add(remoteOutboundTable)
            .add(remoteOutboundForm)
            .asElement();
        expressionElements.put("html41", html41);
        navigation.addSecondary("remoting-outbound-connection-item", "remoting-remote-outbound-sub-item", "Remote Outbound", remotingRemoteOutboundSubItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(connectorTable);
        registerAttachable(httpConnectorTable);
        registerAttachable(localOutboundTable);
        registerAttachable(localOutboundForm);
        registerAttachable(outboundTable);
        registerAttachable(outboundForm);
        registerAttachable(remoteOutboundTable);
        registerAttachable(remoteOutboundForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            localOutboundTable.bindForm(localOutboundForm);
            outboundTable.bindForm(outboundForm);
            remoteOutboundTable.bindForm(remoteOutboundForm);

        TemplateUtil.replaceExpression(expressionElements.get("html29"), "${metadata10.getDescription().getDescription()}", String.valueOf(metadata10.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html31"), "${metadata11.getDescription().getDescription()}", String.valueOf(metadata11.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html33"), "${metadata12.getDescription().getDescription()}", String.valueOf(metadata12.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html35"), "${metadata13.getDescription().getDescription()}", String.valueOf(metadata13.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html38"), "${metadata14.getDescription().getDescription()}", String.valueOf(metadata14.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html41"), "${metadata15.getDescription().getDescription()}", String.valueOf(metadata15.getDescription().getDescription()));
    }
}
