package org.jboss.hal.client.configuration.subsystem.coremanagement;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_CoreManagementView extends CoreManagementView {

    private final Metadata metadata116;
    private final Metadata metadata117;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_CoreManagementView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata116Template = AddressTemplate.of("/{selected.profile}/subsystem=core-management/service=configuration-changes");
        this.metadata116 = mbuiContext.metadataRegistry().lookup(metadata116Template);
        AddressTemplate metadata117Template = AddressTemplate.of("/{selected.profile}/subsystem=core-management/process-state-listener=*");
        this.metadata117 = mbuiContext.metadataRegistry().lookup(metadata117Template);
        this.expressionElements = new HashMap<>();

        confChangesForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("core-mgmt-conf-change-form", metadata116)
            .singleton(
                () -> new Operation.Builder(metadata116Template.resolve(mbuiContext.statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> presenter.addConfigurationChanges())
            .prepareRemove(form -> removeSingletonForm("Configuration Changes", metadata116Template.resolve(mbuiContext.statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Configuration Changes", metadata116Template.resolve(mbuiContext.statementContext()), changedValues, metadata116))
            .prepareReset(form -> resetSingletonForm("Configuration Changes", metadata116Template.resolve(mbuiContext.statementContext()), form, metadata116))
            .build();
        prcStateListenerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("core-mgmt-prc-state-form", metadata117)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Process State Listeners", name, metadata117Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata117);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Process State Listeners", name, metadata117Template.resolve(mbuiContext.statementContext(), name), form, metadata117);
            })
            .build();

        prcStateListenerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("core-mgmt-prc-state-table", metadata117)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("core-mgmt-prc-state-table", Ids.ADD), "Process State Listeners",
                metadata117Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Process State Listeners", metadata117Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html348;
        HTMLElement coreMgmtConfChangeItemElement = section()
            .add(html348 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration Changes</h1><p>${metadata116.getDescription().getDescription()}</p>"))
                .asElement())
            .add(confChangesForm)
            .asElement();
        expressionElements.put("html348", html348);
        navigation.addPrimary("core-mgmt-conf-change-item", "Configuration Changes", "pficon pficon-settings", coreMgmtConfChangeItemElement);
        HTMLElement html350;
        HTMLElement coreMgmtPrcStateItemElement = section()
            .add(html350 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Process State Listeners</h1><p>${metadata117.getDescription().getDescription()}</p>"))
                .asElement())
            .add(prcStateListenerTable)
            .add(prcStateListenerForm)
            .asElement();
        expressionElements.put("html350", html350);
        navigation.addPrimary("core-mgmt-prc-state-item", "Process State Listeners", "pficon pficon-memory", coreMgmtPrcStateItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(confChangesForm);
        registerAttachable(prcStateListenerTable);
        registerAttachable(prcStateListenerForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();


        TemplateUtil.replaceExpression(expressionElements.get("html348"), "${metadata116.getDescription().getDescription()}", String.valueOf(metadata116.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html350"), "${metadata117.getDescription().getDescription()}", String.valueOf(metadata117.getDescription().getDescription()));
    }
}
