package org.jboss.hal.core.runtime.server;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.HandlerRegistration;

import com.google.gwt.event.shared.HasHandlers;

public class ServerSelectionEvent extends GwtEvent<ServerSelectionEvent.ServerSelectionHandler> { 

  java.lang.String server;

  protected ServerSelectionEvent() {
    // Possibly for serialization.
  }

  public ServerSelectionEvent(java.lang.String server) {
    this.server = server;
  }

  public static void fire(HasHandlers source, java.lang.String server) {
    ServerSelectionEvent eventInstance = new ServerSelectionEvent(server);
    source.fireEvent(eventInstance);
  }

  public static void fire(HasHandlers source, ServerSelectionEvent eventInstance) {
    source.fireEvent(eventInstance);
  }

  public interface HasServerSelectionHandlers extends HasHandlers {
    HandlerRegistration addServerSelectionHandler(ServerSelectionHandler handler);
  }

  public interface ServerSelectionHandler extends EventHandler {
    public void onServerSelection(ServerSelectionEvent event);
  }

  private static final Type<ServerSelectionHandler> TYPE = new Type<ServerSelectionHandler>();

  public static Type<ServerSelectionHandler> getType() {
    return TYPE;
  }

  @Override
  public Type<ServerSelectionHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(ServerSelectionHandler handler) {
    handler.onServerSelection(this);
  }

  public java.lang.String getServer(){
    return server;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
        return true;
    if (obj == null)
        return false;
    if (getClass() != obj.getClass())
        return false;
    ServerSelectionEvent other = (ServerSelectionEvent) obj;
    if (server == null) {
      if (other.server != null)
        return false;
    } else if (!server.equals(other.server))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    int hashCode = 23;
    hashCode = (hashCode * 37) + (server == null ? 1 : server.hashCode());
    return hashCode;
  }

  @Override
  public String toString() {
    return "ServerSelectionEvent["
                 + server
    + "]";
  }
}
