package org.jboss.hal.core.runtime.group;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.HandlerRegistration;

import com.google.gwt.event.shared.HasHandlers;

public class ServerGroupSelectionEvent extends GwtEvent<ServerGroupSelectionEvent.ServerGroupSelectionHandler> { 

  java.lang.String serverGroup;

  protected ServerGroupSelectionEvent() {
    // Possibly for serialization.
  }

  public ServerGroupSelectionEvent(java.lang.String serverGroup) {
    this.serverGroup = serverGroup;
  }

  public static void fire(HasHandlers source, java.lang.String serverGroup) {
    ServerGroupSelectionEvent eventInstance = new ServerGroupSelectionEvent(serverGroup);
    source.fireEvent(eventInstance);
  }

  public static void fire(HasHandlers source, ServerGroupSelectionEvent eventInstance) {
    source.fireEvent(eventInstance);
  }

  public interface HasServerGroupSelectionHandlers extends HasHandlers {
    HandlerRegistration addServerGroupSelectionHandler(ServerGroupSelectionHandler handler);
  }

  public interface ServerGroupSelectionHandler extends EventHandler {
    public void onServerGroupSelection(ServerGroupSelectionEvent event);
  }

  private static final Type<ServerGroupSelectionHandler> TYPE = new Type<ServerGroupSelectionHandler>();

  public static Type<ServerGroupSelectionHandler> getType() {
    return TYPE;
  }

  @Override
  public Type<ServerGroupSelectionHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(ServerGroupSelectionHandler handler) {
    handler.onServerGroupSelection(this);
  }

  public java.lang.String getServerGroup(){
    return serverGroup;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
        return true;
    if (obj == null)
        return false;
    if (getClass() != obj.getClass())
        return false;
    ServerGroupSelectionEvent other = (ServerGroupSelectionEvent) obj;
    if (serverGroup == null) {
      if (other.serverGroup != null)
        return false;
    } else if (!serverGroup.equals(other.serverGroup))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    int hashCode = 23;
    hashCode = (hashCode * 37) + (serverGroup == null ? 1 : serverGroup.hashCode());
    return hashCode;
  }

  @Override
  public String toString() {
    return "ServerGroupSelectionEvent["
                 + serverGroup
    + "]";
  }
}
