package org.jboss.hal.client.configuration.subsystem.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_SecurityDomainView extends SecurityDomainView {

    private final Metadata metadata63;
    private final Metadata metadata58;
    private final Metadata metadata59;
    private final Metadata metadata62;
    private final Metadata metadata60;
    private final Metadata metadata61;
    private final Metadata metadata57;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_SecurityDomainView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata63Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*");
        this.metadata63 = mbuiContext.metadataRegistry().lookup(metadata63Template);
        AddressTemplate metadata58Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/authentication=classic/login-module=*");
        this.metadata58 = mbuiContext.metadataRegistry().lookup(metadata58Template);
        AddressTemplate metadata59Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/authorization=classic/policy-module=*");
        this.metadata59 = mbuiContext.metadataRegistry().lookup(metadata59Template);
        AddressTemplate metadata62Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/mapping=classic/mapping-module=*");
        this.metadata62 = mbuiContext.metadataRegistry().lookup(metadata62Template);
        AddressTemplate metadata60Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/audit=classic/provider-module=*");
        this.metadata60 = mbuiContext.metadataRegistry().lookup(metadata60Template);
        AddressTemplate metadata61Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/acl=classic/acl-module=*");
        this.metadata61 = mbuiContext.metadataRegistry().lookup(metadata61Template);
        AddressTemplate metadata57Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*");
        this.metadata57 = mbuiContext.metadataRegistry().lookup(metadata57Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-domain-configuration-form", metadata57)
            .onSave((form, changedValues) -> presenter.saveSecurityDomain(changedValues))
            .prepareReset(form -> presenter.resetSecurityDomain(form))
            .build();
        authenticationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authentication-form", metadata58)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.AUTHENTICATION))
            .prepareReset(form -> presenter.resetModule(form, Module.AUTHENTICATION))
            .build();
        authorizationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authorization-form", metadata59)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.AUTHORIZATION))
            .prepareReset(form -> presenter.resetModule(form, Module.AUTHORIZATION))
            .build();
        auditForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-audit-form", metadata60)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.AUDIT))
            .prepareReset(form -> presenter.resetModule(form, Module.AUDIT))
            .build();
        aclForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-acl-form", metadata61)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.ACL))
            .prepareReset(form -> presenter.resetModule(form, Module.ACL))
            .build();
        trustForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-trust-form", metadata63)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.TRUST))
            .prepareReset(form -> presenter.resetModule(form, Module.TRUST))
            .build();
        mappingForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-mapping-form", metadata62)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.MAPPING))
            .prepareReset(form -> presenter.resetModule(form, Module.MAPPING))
            .build();

        authenticationTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authentication-table", metadata58)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addClassicAuthenticationModule(), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authentication=classic/login-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.AUTHENTICATION), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authentication=classic/login-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        authorizationTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authorization-table", metadata59)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.AUTHORIZATION), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authorization=classic/policy-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.AUTHORIZATION), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authorization=classic/policy-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        auditTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-audit-table", metadata60)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.AUDIT), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/audit=classic/provider-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.AUDIT), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/audit=classic/provider-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        aclTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-acl-table", metadata61)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.ACL), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/acl=classic/acl-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.ACL), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/acl=classic/acl-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        trustTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-trust-table", metadata63)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.TRUST), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.TRUST), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        mappingTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-mapping-table", metadata62)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.MAPPING), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/mapping=classic/mapping-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.MAPPING), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/mapping=classic/mapping-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html177;
        HTMLElement securityDomainConfigurationItemElement = section()
            .add(html177 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata57.getDescription().getDescription()}</p>"))
                .asElement())
            .add(configurationForm)
            .asElement();
        expressionElements.put("html177", html177);
        navigation.addPrimary("security-domain-configuration-item", "Configuration", "pficon pficon-settings", securityDomainConfigurationItemElement);
        HTMLElement html179;
        HTMLElement securityDomainAuthenticationItemElement = section()
            .add(html179 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Authentication Module</h1><p>${metadata58.getDescription().getDescription()}</p>"))
                .asElement())
            .add(authenticationTable)
            .add(authenticationForm)
            .asElement();
        expressionElements.put("html179", html179);
        navigation.addPrimary("security-domain-authentication-item", "Authentication", "fa fa-sign-in", securityDomainAuthenticationItemElement);
        HTMLElement html182;
        HTMLElement securityDomainAuthorizationItemElement = section()
            .add(html182 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Authorization Module</h1><p>${metadata59.getDescription().getDescription()}</p>"))
                .asElement())
            .add(authorizationTable)
            .add(authorizationForm)
            .asElement();
        expressionElements.put("html182", html182);
        navigation.addPrimary("security-domain-authorization-item", "Authorization", "fa fa-shield", securityDomainAuthorizationItemElement);
        HTMLElement html185;
        HTMLElement securityDomainAuditItemElement = section()
            .add(html185 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Audit Module</h1><p>${metadata60.getDescription().getDescription()}</p>"))
                .asElement())
            .add(auditTable)
            .add(auditForm)
            .asElement();
        expressionElements.put("html185", html185);
        navigation.addPrimary("security-domain-audit-item", "Audit", "fa fa-file-text-o", securityDomainAuditItemElement);
        HTMLElement html188;
        HTMLElement securityDomainAclItemElement = section()
            .add(html188 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>ACL Module</h1><p>${metadata61.getDescription().getDescription()}</p>"))
                .asElement())
            .add(aclTable)
            .add(aclForm)
            .asElement();
        expressionElements.put("html188", html188);
        navigation.addPrimary("security-domain-acl-item", "ACL", "fa fa-lock", securityDomainAclItemElement);
        HTMLElement html191;
        HTMLElement securityDomainMappingItemElement = section()
            .add(html191 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Mapping Module</h1><p>${metadata62.getDescription().getDescription()}</p>"))
                .asElement())
            .add(mappingTable)
            .add(mappingForm)
            .asElement();
        expressionElements.put("html191", html191);
        navigation.addPrimary("security-domain-mapping-item", "Mapping", "fa fa-exchange", securityDomainMappingItemElement);
        HTMLElement html194;
        HTMLElement securityDomainTrustItemElement = section()
            .add(html194 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Trust Module</h1><p>${metadata63.getDescription().getDescription()}</p>"))
                .asElement())
            .add(trustTable)
            .add(trustForm)
            .asElement();
        expressionElements.put("html194", html194);
        navigation.addPrimary("security-domain-trust-item", "Identity Trust", "fa fa-handshake-o", securityDomainTrustItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(authenticationTable);
        registerAttachable(authenticationForm);
        registerAttachable(authorizationTable);
        registerAttachable(authorizationForm);
        registerAttachable(auditTable);
        registerAttachable(auditForm);
        registerAttachable(aclTable);
        registerAttachable(aclForm);
        registerAttachable(trustTable);
        registerAttachable(trustForm);
        registerAttachable(mappingTable);
        registerAttachable(mappingForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            authenticationTable.bindForm(authenticationForm);
            authorizationTable.bindForm(authorizationForm);
            auditTable.bindForm(auditForm);
            aclTable.bindForm(aclForm);
            trustTable.bindForm(trustForm);
            mappingTable.bindForm(mappingForm);

        TemplateUtil.replaceExpression(expressionElements.get("html177"), "${metadata57.getDescription().getDescription()}", String.valueOf(metadata57.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html179"), "${metadata58.getDescription().getDescription()}", String.valueOf(metadata58.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html182"), "${metadata59.getDescription().getDescription()}", String.valueOf(metadata59.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html185"), "${metadata60.getDescription().getDescription()}", String.valueOf(metadata60.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html188"), "${metadata61.getDescription().getDescription()}", String.valueOf(metadata61.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html191"), "${metadata62.getDescription().getDescription()}", String.valueOf(metadata62.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html194"), "${metadata63.getDescription().getDescription()}", String.valueOf(metadata63.getDescription().getDescription()));
    }
}
